#pragma once

#include "mbed.h"
#include "TLC59116.h"
#include "Color.h"

enum DistanceSensor{
    FRONT_LEFT,
    FRONT_MIDDLE_LEFT,
    BACK_MIDDLE_LEFT,
    BACK_LEFT,
    BACK_RIGHT,
    BACK_MIDDLE_RIGHT,
    FRONT_MIDDLE_RIGHT,
    FRONT_RIGHT  
}; 

class LedRing{
    public:
    LedRing(I2C &i2c);
    LedRing(PinName sda, PinName scl);
    
    void setColor(int led, Color* Color);
    void setColor(int led, int color);
    void setAll(int color);
    void setAll(Color* color);
    void setAll(int* colors);
    void setBrightness(float brightness);
    
    void greenRedGradient(int led, int value);
    
    protected:
    void initialize();
    void setLed(TLC59116* driver, int startChannel, Color* color);
    
    private:
    TLC59116 driver1;
    TLC59116 driver2;
    
    static const int DRIVER_1_ADDRESS = 0xC0;
    static const int DRIVER_2_ADDRESS = 0xC2;
    
};