#pragma once

#include "m3pi.h"

#include "StatusLed.h"
#include "Color.h"
#include "LedRing.h"
#include "hmc5583l.h"
#include "ITG3200.h"
#include "ADXL345_I2C.h"
#include "PCA9547.h"
//#include "vl6108x.h"
#include "vl6180xManager.h"
#include "xbee.h"
#include "datatypes.h"

class M3Dpi : public m3pi
{

public:
    M3Dpi();

    void setStatus(int color);
    void setStatus(Color* color);

    void setLeds(int* colors);
    m3dpi::Distance getDistance();
    m3dpi::Direction getDirection(); // compass
    m3dpi::Rotation getRotation(); // gyro
    m3dpi::Acceleration getAcceleration();
    time_t getTime();

    // buttonhandler (interrupt based?)

    //protected:    // public for hardware testing only
    
    I2C i2c;
    
    StatusLed status;
    LedRing leds;

    HMC5583L compass;
    ITG3200 gyro;
    ADXL345_I2C accelerometer;
    VL6180xManager distance;
    Xbee xbee;

    static const PinName SDA = p28;
    static const PinName SCL = p27;
    static const PinName XBEE_TX = p13;
    static const PinName XBEE_RX = p14;
    static const PinName XBEE_RESET = p12;
    static const PinName STATUS_RED = p18;
    static const PinName STATUS_GREEN = p19;
    static const PinName STATUS_BLUE = p20;

    static const int XBEE_BAUD = 57600;

    virtual int _putc(int c);
    virtual int _getc();

};