#pragma once

#include "mbed.h"
#include "M3Dpi.h"

// TODO: only report if value is different?
class Reporter
{
protected:
    mbed::Stream* out;
    const char* id;
public:
    Reporter(mbed::Stream* _out, const char _id[]);
    virtual void time(time_t seconds) = 0;
    virtual void distance(m3dpi::Distance distance) = 0;
    virtual void acceleration(m3dpi::Acceleration acc) = 0;
    virtual void direction(m3dpi::Direction direction) = 0;
    virtual void rotation(m3dpi::Rotation rotation) = 0;
};