#include "binaryReporter.h"

void BinaryReporter::print(char* data, int size)
{
    for(int i = 0; i < size; i++){
        out->putc(data[i]);
    }
}

void BinaryReporter::time(time_t seconds)
{

}

void BinaryReporter::distance(m3dpi::Distance distance)
{
    const int SIZE = 13;
    char data[SIZE] = {START,'a', SIZE-1, DISTANCE};
    data [4] = distance.front;
    data [5] = distance.front_right;
    data [6] = distance.right;
    data [7] = distance.back_right;
    data [8] = distance.back;
    data [9] = distance.back_left;
    data [10] = distance.left;
    data [11] = distance.front_left;
    data [12] = 0x00; // checksum
    print(data, SIZE);
}

void BinaryReporter::acceleration(m3dpi::Acceleration acc)
{
    const int SIZE = 11;
    char data[SIZE] = {START,'a', SIZE-1, ACCELERATION};
    data[4] = acc.x / 256;
    data[5] = acc.x % 256;
    data[6] = acc.y / 256;
    data[5] = acc.y % 256;
    data[8] = acc.z / 256;
    data[9] = acc.z % 256;
    data [10] = 0x00; // checksum
    print(data, SIZE);
}

void BinaryReporter::direction(m3dpi::Direction direction)
{
    const int SIZE = 11;
    char data[SIZE] = {START,'a', SIZE-1, DIRECTION};
    data[4] = direction.x / 256;
    data[5] = direction.x % 256;
    data[6] = direction.y / 256;
    data[5] = direction.y % 256;
    data[8] = direction.z / 256;
    data[9] = direction.z % 256;
    data [10] = 0x00; // checksum
    print(data, SIZE);
}

void BinaryReporter::rotation(m3dpi::Rotation rotation)
{
    const int SIZE = 11;
    char data[SIZE] = {START,'a', SIZE-1, ROTATION};
    data[4] = rotation.x / 256;
    data[5] = rotation.x % 256;
    data[6] = rotation.y / 256;
    data[5] = rotation.y % 256;
    data[8] = rotation.z / 256;
    data[9] = rotation.z % 256;
    data [10] = 0x00; // checksum
    print(data, SIZE);
}
