#pragma once

#include "reporter.h"

class BinaryReporter : public Reporter
{
    static const char START = 0x02;
    void print(char* data, int size);
    
    enum COMMAND {
        DISTANCE = 10, 
        DIRECTION = 11, 
        ROTATION = 13, 
        ACCELERATION = 14
    };
    
public:
    BinaryReporter(mbed::Stream* _out, const char _id[]) : Reporter(_out, _id) {};

    virtual void time(time_t seconds);
    virtual void distance(m3dpi::Distance distance);
    virtual void acceleration(m3dpi::Acceleration acc);
    virtual void direction(m3dpi::Direction direction);
    virtual void rotation(m3dpi::Rotation rotation);
    

};