#include "mbed.h"
#include "rtos.h"
#include "M3Dpi.h"
#include "jsonReporter.h"
#include "binaryReporter.h"

const char M3DPI_ID[] = "1234567890";

M3Dpi robot;
Serial pc(USBTX,USBRX);
Reporter* report = new JsonReporter(&robot.xbee, M3DPI_ID);

m3dpi::Distance distance;
m3dpi::Direction direction;
m3dpi::Rotation rotation;
m3dpi::Acceleration acceleration;


void setLeds(m3dpi::Distance distance)
{
    int colors[8] = {distance.front, distance.front_right, distance.right, distance.back_right, distance.back, distance.back_left, distance.left, distance.front_left};
    // shift distance value to get red colors
    for(int i = 0; i < 8; i++){
        //colors[i] = ((~(colors[i]*2)) & 0xFF) << 16;
        if(colors[i] < 50) {colors[i] = Color::RED;}
        else if(colors[i] < 100) {colors[i] = Color::YELLOW;}
        else if(colors[i] < 150) {colors[i] = Color::GREEN;}
        else{colors[i] = Color::BLACK;}
    }
    robot.setLeds(colors);
}

void read_sensors_task(void const *name)
{
    //Timer t; t.start();
    robot.setStatus(Color::BLACK);
    ::distance = robot.getDistance();
    //direction = robot.getDirection();
    //rotation = robot.getRotation();
    //acceleration = robot.getAcceleration();
    setLeds(::distance);
    robot.setStatus(Color::RED);
    //t.stop();pc.printf("*** Sensor acquisition time: %d us\r\n", t.read_us());
}

void report_task(void const *name)
{
    //Timer t; t.start();
    report->distance(::distance);
    report->direction(direction);
    report->rotation(rotation);
    report->acceleration(acceleration);
    //t.stop();pc.printf("*** Report time: %d us\r\n", t.read_us());
}

void receive_task(void const *name)
{
    
}

void idle_task(void const *name)
{
    
}

int main()
{            
    pc.baud(115200);
    
    RtosTimer read_sensors_timer(read_sensors_task, osTimerPeriodic);
    read_sensors_timer.start(50);
    
    RtosTimer report_timer(report_task, osTimerPeriodic);
//    report_timer.start(500);
    
//    Thread receive_thread(receive_task);
//    Thread idle_thread(idle_task, NULL, osPriorityLow);
    
    Thread::wait(osWaitForever);
}