#include "jsonReporter.h"

MbedJSONValue* JsonReporter::jsonFactory()
{
    MbedJSONValue* json = new MbedJSONValue();
    (*json)["id"] = id;
    return json;
}

void JsonReporter::print(MbedJSONValue* json)
{
    out->printf("%s\n", json->serialize().c_str());
}

void JsonReporter::time(time_t seconds)
{
    char buffer[32];
    std::strftime(buffer, 32, "%d-%m-%Y %T", localtime(&seconds));
    MbedJSONValue* jsonTime = jsonFactory();
    (*jsonTime)["time"] = buffer;
    print(jsonTime);
    delete jsonTime;   
}

void JsonReporter::distance(m3dpi::Distance distance)
{
    MbedJSONValue* json = jsonFactory();
    const char property[] = "distance";

    (*json)[property][0] = distance.front;
    (*json)[property][1] = distance.front_right;
    (*json)[property][2] = distance.right;
    (*json)[property][3] = distance.back_right;
    (*json)[property][4] = distance.back;
    (*json)[property][5] = distance.back_left;
    (*json)[property][6] = distance.left;
    (*json)[property][7] = distance.front_left;

    print(json);
    delete json;
}

void JsonReporter::acceleration(m3dpi::Acceleration acc)
{
    MbedJSONValue* json = jsonFactory();
    const char property[] = "acceleration";
    
    (*json)[property]["x"] = acc.x;
    (*json)[property]["y"] = acc.y;
    (*json)[property]["z"] = acc.z;
    
    print(json);
    delete json;
}

void JsonReporter::direction(m3dpi::Direction direction)
{
    MbedJSONValue* json = jsonFactory();
    const char property[] = "direction";
    
    (*json)[property]["x"] = direction.x;
    (*json)[property]["y"] = direction.y;
    (*json)[property]["z"] = direction.z;
    
    print(json);
    delete json;
}

void JsonReporter::rotation(m3dpi::Rotation rotation)
{
    MbedJSONValue* json = jsonFactory();
    const char property[] = "rotation";
    
    (*json)[property]["x"] = rotation.x;
    (*json)[property]["y"] = rotation.y;
    (*json)[property]["z"] = rotation.z;
    
    print(json);
    delete json;
}
