#include "mbed.h"
#include "coap.h"
#include "LM75B.h"
#include "RGB.h"
#include <string> 

LM75B sensor(p28,p27);
RGB led(p23,p24,p25);
 
void get_hello(Request* req, Response* res)
{
     res->setContent("Hello world\r\n", 13);
}

void get_temp(Request* req, Response* res)
{
    if (sensor.open()) {
        char temp[20];
        int count = sprintf(temp, "%.3f", (float)sensor);
        res->setContent(temp, count);
    } else {
        res->setCode(SERVICE_UNAVAILABLE);
    }
}

void get_led(Request* req, Response* res)
{
    char data[20];
    Color* color = led.getColor();
    int count = sprintf(data, "#%06d", color->getHex());
    res->setContent(data, count);
}

void post_led(Request* req, Response* res)
{
    Color color((int) std::strtol(req->getContent(), 0, 16));
    led.setColor(&color);
    res->setCode(CHANGED);
}

            
int main() {
    Server server;
    
    server.enableBroadcast();
    
    server.add("/hello",   &get_hello, GET);
    server.add("/temp", &get_temp, GET);
    server.add("/led", &get_led, GET);
    server.add("/led", &post_led, POST);
    
    while(1)
    {
        server.waitForRequest();  
    };
}
