#include "C12832.h"
#include "LM75B.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "rtos.h"
#include "MbedJSONValue.h"
#include "RGB.h"

/*** IMPORTANT !!! 
 * Change the following values 
 */
 
char* hostname = "mqtt.labict.be";
char* temperature_topic = "softwareengineering/thermostat/YOURSENSORID/temperature";
char* led_topic = "softwareengineering/thermostat/YOURSENSORID/led";
int port = 1883;
char* clientId = "myrandomstringclientid";

//#define K64F 1

#ifdef K64F
    C12832 lcd(D11, D13, D12, D7, D10);
    LM75B sensor(D14,D15);   
    RGB led(p23,p24,p25);
#else   //LPC1768
    C12832 lcd(p5, p7, p6, p8, p11); 
    LM75B sensor(p28,p27); 
    RGB led(p23,p24,p25);
#endif

MQTT::Client<MQTTEthernet, Countdown>* client;

void send_temperature(void const * arg)
{
    while(true){
        char buf[100];
        sprintf(buf, "{\"temperature\": %.2f}", sensor.read());
        
        MQTT::Message message;
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        client->publish(temperature_topic, message); 
        
        Thread::wait(5000);     
    }
}

void process_rgb(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    lcd.cls();
    lcd.locate(0,3);
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    lcd.puts((char*)message.payload);
    
    char buffer[32] = {0};
    memcpy(buffer, message.payload, message.payloadlen);
    
    MbedJSONValue payload;
    parse(payload, buffer);
    
    std::string color_string = payload["color"].get<std::string>();
    printf("Color: %s\n", color_string.c_str());
    
    Color color((int) std::strtol(color_string.c_str(), 0, 16));
    led.setColor(&color);
}

int main(int argc, char* argv[])
{   
    MQTTEthernet ipstack = MQTTEthernet();
    
    client = new MQTT::Client<MQTTEthernet, Countdown>(ipstack);
    
    lcd.printf("Connecting to %s:%d\n", hostname, port);
    int rc = ipstack.connect(hostname, port);
    if (rc != 0)
        lcd.printf("rc from TCP connect is %d\n", rc);
 
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = clientId;

    if ((rc = client->connect(data)) != 0)
        lcd.printf("rc from MQTT connect is %d\n", rc);
        
    if ((rc = client->subscribe(led_topic, MQTT::QOS1, process_rgb)) != 0)
        lcd.printf("rc from MQTT subscribe is %d\n", rc);
    

    Thread send_thread(send_temperature);


    while(true){
        client->yield(100);    
    }

    
    return 0;
}
