#pragma once

#include "LoggerInterface.h"
#include "mbed.h"

class LogIt : public Log::LoggerInterface
{
    public:
    LogIt(mbed::Serial* serial);
    void emergency(const char* message, ...);
    void alert(const char* message, ...);
    void critical(const char* message, ...);
    void error(const char* message, ...);
    void warning(const char* message, ...);
    void notice(const char* message, ...);
    void info(const char* message, ...);
    void debug(const char* message, ...);
    void log(Level level, const char* message, ...);

    void setLevel(Level level);

    protected:
    void log(Level level, const char* message,  va_list args);
    mbed::Serial* serial;
    Level level; // minimum level to log
};
