#include "hmc5583l.h"
#include "stdint.h"

HMC5583L::HMC5583L(I2C &_i2c, int _address): i2c(_i2c), address(_address)
{
    initialize();
}

HMC5583L::HMC5583L(PinName sda, PinName scl, int _address): i2c(sda, scl), address(_address)
{
    initialize();
}

void HMC5583L::initialize()
{
    char data[2];
    data[0] = 0x02; // select mode register
    data[1] = 0x00; // continous measurement mode

    i2c.write(address, data, 2);   
}

coord HMC5583L::getCompass()
{
    coord c;
    // tell where to begin reading data
    char data[] = {0x03}; // select register 3, MSB register
    i2c.write(address, data, 1);
    
    char values[6];
    i2c.read(address, values, 6);
    
    // x = (x >> 11) == 0 ? x : -1 ^ 0xFFF | x;
    c.x = regToInt(values[0], values[1]);
    c.y = regToInt(values[2], values[3]);
    c.z = regToInt(values[4], values[5]);
        
    return c;
}

int HMC5583L::regToInt(char msb, char lsb){
    int16_t value = msb << 8 | lsb;
    return (int) value;
}