/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_LLWU_REGISTERS_H__
#define __HW_LLWU_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 LLWU
 *
 * Low leakage wakeup unit
 *
 * Registers defined in this header file:
 * - HW_LLWU_PE1 - LLWU Pin Enable 1 register
 * - HW_LLWU_PE2 - LLWU Pin Enable 2 register
 * - HW_LLWU_PE3 - LLWU Pin Enable 3 register
 * - HW_LLWU_PE4 - LLWU Pin Enable 4 register
 * - HW_LLWU_ME - LLWU Module Enable register
 * - HW_LLWU_F1 - LLWU Flag 1 register
 * - HW_LLWU_F2 - LLWU Flag 2 register
 * - HW_LLWU_F3 - LLWU Flag 3 register
 * - HW_LLWU_FILT1 - LLWU Pin Filter 1 register
 * - HW_LLWU_FILT2 - LLWU Pin Filter 2 register
 * - HW_LLWU_RST - LLWU Reset Enable register
 *
 * - hw_llwu_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_LLWU_BASE
#define HW_LLWU_INSTANCE_COUNT (1U) //!< Number of instances of the LLWU module.
#define REGS_LLWU_BASE (0x4007C000U) //!< Base address for LLWU.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_PE1 - LLWU Pin Enable 1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_PE1 - LLWU Pin Enable 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE1 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P3-LLWU_P0. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe1
{
    uint8_t U;
    struct _hw_llwu_pe1_bitfields
    {
        uint8_t WUPE0 : 2;             //!< [1:0] Wakeup Pin Enable For LLWU_P0
        uint8_t WUPE1 : 2;             //!< [3:2] Wakeup Pin Enable For LLWU_P1
        uint8_t WUPE2 : 2;             //!< [5:4] Wakeup Pin Enable For LLWU_P2
        uint8_t WUPE3 : 2;             //!< [7:6] Wakeup Pin Enable For LLWU_P3
    } B;
} hw_llwu_pe1_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_PE1 register
 */
//@{
#define HW_LLWU_PE1_ADDR         (REGS_LLWU_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_PE1              (*(__IO hw_llwu_pe1_t *) HW_LLWU_PE1_ADDR)
#define HW_LLWU_PE1_RD()         (HW_LLWU_PE1.U)
#define HW_LLWU_PE1_WR(v)        (HW_LLWU_PE1.U = (v))
#define HW_LLWU_PE1_SET(v)       (HW_LLWU_PE1_WR(HW_LLWU_PE1_RD() |  (v)))
#define HW_LLWU_PE1_CLR(v)       (HW_LLWU_PE1_WR(HW_LLWU_PE1_RD() & ~(v)))
#define HW_LLWU_PE1_TOG(v)       (HW_LLWU_PE1_WR(HW_LLWU_PE1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_PE1 bitfields
 */

/*!
 * @name Register LLWU_PE1, field WUPE0[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE1_WUPE0    (0U)          //!< Bit position for LLWU_PE1_WUPE0.
#define BM_LLWU_PE1_WUPE0    (0x03U)       //!< Bit mask for LLWU_PE1_WUPE0.
#define BS_LLWU_PE1_WUPE0    (2U)          //!< Bit field size in bits for LLWU_PE1_WUPE0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE1_WUPE0 field.
#define BR_LLWU_PE1_WUPE0    (HW_LLWU_PE1.B.WUPE0)
#endif

//! @brief Format value for bitfield LLWU_PE1_WUPE0.
#define BF_LLWU_PE1_WUPE0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE1_WUPE0), uint8_t) & BM_LLWU_PE1_WUPE0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE0 field to a new value.
#define BW_LLWU_PE1_WUPE0(v) (HW_LLWU_PE1_WR((HW_LLWU_PE1_RD() & ~BM_LLWU_PE1_WUPE0) | BF_LLWU_PE1_WUPE0(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE1, field WUPE1[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE1_WUPE1    (2U)          //!< Bit position for LLWU_PE1_WUPE1.
#define BM_LLWU_PE1_WUPE1    (0x0CU)       //!< Bit mask for LLWU_PE1_WUPE1.
#define BS_LLWU_PE1_WUPE1    (2U)          //!< Bit field size in bits for LLWU_PE1_WUPE1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE1_WUPE1 field.
#define BR_LLWU_PE1_WUPE1    (HW_LLWU_PE1.B.WUPE1)
#endif

//! @brief Format value for bitfield LLWU_PE1_WUPE1.
#define BF_LLWU_PE1_WUPE1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE1_WUPE1), uint8_t) & BM_LLWU_PE1_WUPE1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE1 field to a new value.
#define BW_LLWU_PE1_WUPE1(v) (HW_LLWU_PE1_WR((HW_LLWU_PE1_RD() & ~BM_LLWU_PE1_WUPE1) | BF_LLWU_PE1_WUPE1(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE1, field WUPE2[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE1_WUPE2    (4U)          //!< Bit position for LLWU_PE1_WUPE2.
#define BM_LLWU_PE1_WUPE2    (0x30U)       //!< Bit mask for LLWU_PE1_WUPE2.
#define BS_LLWU_PE1_WUPE2    (2U)          //!< Bit field size in bits for LLWU_PE1_WUPE2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE1_WUPE2 field.
#define BR_LLWU_PE1_WUPE2    (HW_LLWU_PE1.B.WUPE2)
#endif

//! @brief Format value for bitfield LLWU_PE1_WUPE2.
#define BF_LLWU_PE1_WUPE2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE1_WUPE2), uint8_t) & BM_LLWU_PE1_WUPE2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE2 field to a new value.
#define BW_LLWU_PE1_WUPE2(v) (HW_LLWU_PE1_WR((HW_LLWU_PE1_RD() & ~BM_LLWU_PE1_WUPE2) | BF_LLWU_PE1_WUPE2(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE1, field WUPE3[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE1_WUPE3    (6U)          //!< Bit position for LLWU_PE1_WUPE3.
#define BM_LLWU_PE1_WUPE3    (0xC0U)       //!< Bit mask for LLWU_PE1_WUPE3.
#define BS_LLWU_PE1_WUPE3    (2U)          //!< Bit field size in bits for LLWU_PE1_WUPE3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE1_WUPE3 field.
#define BR_LLWU_PE1_WUPE3    (HW_LLWU_PE1.B.WUPE3)
#endif

//! @brief Format value for bitfield LLWU_PE1_WUPE3.
#define BF_LLWU_PE1_WUPE3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE1_WUPE3), uint8_t) & BM_LLWU_PE1_WUPE3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE3 field to a new value.
#define BW_LLWU_PE1_WUPE3(v) (HW_LLWU_PE1_WR((HW_LLWU_PE1_RD() & ~BM_LLWU_PE1_WUPE3) | BF_LLWU_PE1_WUPE3(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_PE2 - LLWU Pin Enable 2 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_PE2 - LLWU Pin Enable 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE2 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P7-LLWU_P4. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe2
{
    uint8_t U;
    struct _hw_llwu_pe2_bitfields
    {
        uint8_t WUPE4 : 2;             //!< [1:0] Wakeup Pin Enable For LLWU_P4
        uint8_t WUPE5 : 2;             //!< [3:2] Wakeup Pin Enable For LLWU_P5
        uint8_t WUPE6 : 2;             //!< [5:4] Wakeup Pin Enable For LLWU_P6
        uint8_t WUPE7 : 2;             //!< [7:6] Wakeup Pin Enable For LLWU_P7
    } B;
} hw_llwu_pe2_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_PE2 register
 */
//@{
#define HW_LLWU_PE2_ADDR         (REGS_LLWU_BASE + 0x1U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_PE2              (*(__IO hw_llwu_pe2_t *) HW_LLWU_PE2_ADDR)
#define HW_LLWU_PE2_RD()         (HW_LLWU_PE2.U)
#define HW_LLWU_PE2_WR(v)        (HW_LLWU_PE2.U = (v))
#define HW_LLWU_PE2_SET(v)       (HW_LLWU_PE2_WR(HW_LLWU_PE2_RD() |  (v)))
#define HW_LLWU_PE2_CLR(v)       (HW_LLWU_PE2_WR(HW_LLWU_PE2_RD() & ~(v)))
#define HW_LLWU_PE2_TOG(v)       (HW_LLWU_PE2_WR(HW_LLWU_PE2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_PE2 bitfields
 */

/*!
 * @name Register LLWU_PE2, field WUPE4[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE2_WUPE4    (0U)          //!< Bit position for LLWU_PE2_WUPE4.
#define BM_LLWU_PE2_WUPE4    (0x03U)       //!< Bit mask for LLWU_PE2_WUPE4.
#define BS_LLWU_PE2_WUPE4    (2U)          //!< Bit field size in bits for LLWU_PE2_WUPE4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE2_WUPE4 field.
#define BR_LLWU_PE2_WUPE4    (HW_LLWU_PE2.B.WUPE4)
#endif

//! @brief Format value for bitfield LLWU_PE2_WUPE4.
#define BF_LLWU_PE2_WUPE4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE2_WUPE4), uint8_t) & BM_LLWU_PE2_WUPE4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE4 field to a new value.
#define BW_LLWU_PE2_WUPE4(v) (HW_LLWU_PE2_WR((HW_LLWU_PE2_RD() & ~BM_LLWU_PE2_WUPE4) | BF_LLWU_PE2_WUPE4(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE2, field WUPE5[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE2_WUPE5    (2U)          //!< Bit position for LLWU_PE2_WUPE5.
#define BM_LLWU_PE2_WUPE5    (0x0CU)       //!< Bit mask for LLWU_PE2_WUPE5.
#define BS_LLWU_PE2_WUPE5    (2U)          //!< Bit field size in bits for LLWU_PE2_WUPE5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE2_WUPE5 field.
#define BR_LLWU_PE2_WUPE5    (HW_LLWU_PE2.B.WUPE5)
#endif

//! @brief Format value for bitfield LLWU_PE2_WUPE5.
#define BF_LLWU_PE2_WUPE5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE2_WUPE5), uint8_t) & BM_LLWU_PE2_WUPE5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE5 field to a new value.
#define BW_LLWU_PE2_WUPE5(v) (HW_LLWU_PE2_WR((HW_LLWU_PE2_RD() & ~BM_LLWU_PE2_WUPE5) | BF_LLWU_PE2_WUPE5(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE2, field WUPE6[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE2_WUPE6    (4U)          //!< Bit position for LLWU_PE2_WUPE6.
#define BM_LLWU_PE2_WUPE6    (0x30U)       //!< Bit mask for LLWU_PE2_WUPE6.
#define BS_LLWU_PE2_WUPE6    (2U)          //!< Bit field size in bits for LLWU_PE2_WUPE6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE2_WUPE6 field.
#define BR_LLWU_PE2_WUPE6    (HW_LLWU_PE2.B.WUPE6)
#endif

//! @brief Format value for bitfield LLWU_PE2_WUPE6.
#define BF_LLWU_PE2_WUPE6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE2_WUPE6), uint8_t) & BM_LLWU_PE2_WUPE6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE6 field to a new value.
#define BW_LLWU_PE2_WUPE6(v) (HW_LLWU_PE2_WR((HW_LLWU_PE2_RD() & ~BM_LLWU_PE2_WUPE6) | BF_LLWU_PE2_WUPE6(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE2, field WUPE7[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE2_WUPE7    (6U)          //!< Bit position for LLWU_PE2_WUPE7.
#define BM_LLWU_PE2_WUPE7    (0xC0U)       //!< Bit mask for LLWU_PE2_WUPE7.
#define BS_LLWU_PE2_WUPE7    (2U)          //!< Bit field size in bits for LLWU_PE2_WUPE7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE2_WUPE7 field.
#define BR_LLWU_PE2_WUPE7    (HW_LLWU_PE2.B.WUPE7)
#endif

//! @brief Format value for bitfield LLWU_PE2_WUPE7.
#define BF_LLWU_PE2_WUPE7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE2_WUPE7), uint8_t) & BM_LLWU_PE2_WUPE7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE7 field to a new value.
#define BW_LLWU_PE2_WUPE7(v) (HW_LLWU_PE2_WR((HW_LLWU_PE2_RD() & ~BM_LLWU_PE2_WUPE7) | BF_LLWU_PE2_WUPE7(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_PE3 - LLWU Pin Enable 3 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_PE3 - LLWU Pin Enable 3 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE3 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P11-LLWU_P8. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module
 * (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe3
{
    uint8_t U;
    struct _hw_llwu_pe3_bitfields
    {
        uint8_t WUPE8 : 2;             //!< [1:0] Wakeup Pin Enable For LLWU_P8
        uint8_t WUPE9 : 2;             //!< [3:2] Wakeup Pin Enable For LLWU_P9
        uint8_t WUPE10 : 2;            //!< [5:4] Wakeup Pin Enable For LLWU_P10
        uint8_t WUPE11 : 2;            //!< [7:6] Wakeup Pin Enable For LLWU_P11
    } B;
} hw_llwu_pe3_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_PE3 register
 */
//@{
#define HW_LLWU_PE3_ADDR         (REGS_LLWU_BASE + 0x2U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_PE3              (*(__IO hw_llwu_pe3_t *) HW_LLWU_PE3_ADDR)
#define HW_LLWU_PE3_RD()         (HW_LLWU_PE3.U)
#define HW_LLWU_PE3_WR(v)        (HW_LLWU_PE3.U = (v))
#define HW_LLWU_PE3_SET(v)       (HW_LLWU_PE3_WR(HW_LLWU_PE3_RD() |  (v)))
#define HW_LLWU_PE3_CLR(v)       (HW_LLWU_PE3_WR(HW_LLWU_PE3_RD() & ~(v)))
#define HW_LLWU_PE3_TOG(v)       (HW_LLWU_PE3_WR(HW_LLWU_PE3_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_PE3 bitfields
 */

/*!
 * @name Register LLWU_PE3, field WUPE8[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE3_WUPE8    (0U)          //!< Bit position for LLWU_PE3_WUPE8.
#define BM_LLWU_PE3_WUPE8    (0x03U)       //!< Bit mask for LLWU_PE3_WUPE8.
#define BS_LLWU_PE3_WUPE8    (2U)          //!< Bit field size in bits for LLWU_PE3_WUPE8.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE3_WUPE8 field.
#define BR_LLWU_PE3_WUPE8    (HW_LLWU_PE3.B.WUPE8)
#endif

//! @brief Format value for bitfield LLWU_PE3_WUPE8.
#define BF_LLWU_PE3_WUPE8(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE3_WUPE8), uint8_t) & BM_LLWU_PE3_WUPE8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE8 field to a new value.
#define BW_LLWU_PE3_WUPE8(v) (HW_LLWU_PE3_WR((HW_LLWU_PE3_RD() & ~BM_LLWU_PE3_WUPE8) | BF_LLWU_PE3_WUPE8(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE3, field WUPE9[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE3_WUPE9    (2U)          //!< Bit position for LLWU_PE3_WUPE9.
#define BM_LLWU_PE3_WUPE9    (0x0CU)       //!< Bit mask for LLWU_PE3_WUPE9.
#define BS_LLWU_PE3_WUPE9    (2U)          //!< Bit field size in bits for LLWU_PE3_WUPE9.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE3_WUPE9 field.
#define BR_LLWU_PE3_WUPE9    (HW_LLWU_PE3.B.WUPE9)
#endif

//! @brief Format value for bitfield LLWU_PE3_WUPE9.
#define BF_LLWU_PE3_WUPE9(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE3_WUPE9), uint8_t) & BM_LLWU_PE3_WUPE9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE9 field to a new value.
#define BW_LLWU_PE3_WUPE9(v) (HW_LLWU_PE3_WR((HW_LLWU_PE3_RD() & ~BM_LLWU_PE3_WUPE9) | BF_LLWU_PE3_WUPE9(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE3, field WUPE10[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE3_WUPE10   (4U)          //!< Bit position for LLWU_PE3_WUPE10.
#define BM_LLWU_PE3_WUPE10   (0x30U)       //!< Bit mask for LLWU_PE3_WUPE10.
#define BS_LLWU_PE3_WUPE10   (2U)          //!< Bit field size in bits for LLWU_PE3_WUPE10.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE3_WUPE10 field.
#define BR_LLWU_PE3_WUPE10   (HW_LLWU_PE3.B.WUPE10)
#endif

//! @brief Format value for bitfield LLWU_PE3_WUPE10.
#define BF_LLWU_PE3_WUPE10(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE3_WUPE10), uint8_t) & BM_LLWU_PE3_WUPE10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE10 field to a new value.
#define BW_LLWU_PE3_WUPE10(v) (HW_LLWU_PE3_WR((HW_LLWU_PE3_RD() & ~BM_LLWU_PE3_WUPE10) | BF_LLWU_PE3_WUPE10(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE3, field WUPE11[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE3_WUPE11   (6U)          //!< Bit position for LLWU_PE3_WUPE11.
#define BM_LLWU_PE3_WUPE11   (0xC0U)       //!< Bit mask for LLWU_PE3_WUPE11.
#define BS_LLWU_PE3_WUPE11   (2U)          //!< Bit field size in bits for LLWU_PE3_WUPE11.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE3_WUPE11 field.
#define BR_LLWU_PE3_WUPE11   (HW_LLWU_PE3.B.WUPE11)
#endif

//! @brief Format value for bitfield LLWU_PE3_WUPE11.
#define BF_LLWU_PE3_WUPE11(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE3_WUPE11), uint8_t) & BM_LLWU_PE3_WUPE11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE11 field to a new value.
#define BW_LLWU_PE3_WUPE11(v) (HW_LLWU_PE3_WR((HW_LLWU_PE3_RD() & ~BM_LLWU_PE3_WUPE11) | BF_LLWU_PE3_WUPE11(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_PE4 - LLWU Pin Enable 4 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_PE4 - LLWU Pin Enable 4 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_PE4 contains the field to enable and select the edge detect type for the
 * external wakeup input pins LLWU_P15-LLWU_P12. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_pe4
{
    uint8_t U;
    struct _hw_llwu_pe4_bitfields
    {
        uint8_t WUPE12 : 2;            //!< [1:0] Wakeup Pin Enable For LLWU_P12
        uint8_t WUPE13 : 2;            //!< [3:2] Wakeup Pin Enable For LLWU_P13
        uint8_t WUPE14 : 2;            //!< [5:4] Wakeup Pin Enable For LLWU_P14
        uint8_t WUPE15 : 2;            //!< [7:6] Wakeup Pin Enable For LLWU_P15
    } B;
} hw_llwu_pe4_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_PE4 register
 */
//@{
#define HW_LLWU_PE4_ADDR         (REGS_LLWU_BASE + 0x3U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_PE4              (*(__IO hw_llwu_pe4_t *) HW_LLWU_PE4_ADDR)
#define HW_LLWU_PE4_RD()         (HW_LLWU_PE4.U)
#define HW_LLWU_PE4_WR(v)        (HW_LLWU_PE4.U = (v))
#define HW_LLWU_PE4_SET(v)       (HW_LLWU_PE4_WR(HW_LLWU_PE4_RD() |  (v)))
#define HW_LLWU_PE4_CLR(v)       (HW_LLWU_PE4_WR(HW_LLWU_PE4_RD() & ~(v)))
#define HW_LLWU_PE4_TOG(v)       (HW_LLWU_PE4_WR(HW_LLWU_PE4_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_PE4 bitfields
 */

/*!
 * @name Register LLWU_PE4, field WUPE12[1:0] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE4_WUPE12   (0U)          //!< Bit position for LLWU_PE4_WUPE12.
#define BM_LLWU_PE4_WUPE12   (0x03U)       //!< Bit mask for LLWU_PE4_WUPE12.
#define BS_LLWU_PE4_WUPE12   (2U)          //!< Bit field size in bits for LLWU_PE4_WUPE12.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE4_WUPE12 field.
#define BR_LLWU_PE4_WUPE12   (HW_LLWU_PE4.B.WUPE12)
#endif

//! @brief Format value for bitfield LLWU_PE4_WUPE12.
#define BF_LLWU_PE4_WUPE12(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE4_WUPE12), uint8_t) & BM_LLWU_PE4_WUPE12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE12 field to a new value.
#define BW_LLWU_PE4_WUPE12(v) (HW_LLWU_PE4_WR((HW_LLWU_PE4_RD() & ~BM_LLWU_PE4_WUPE12) | BF_LLWU_PE4_WUPE12(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE4, field WUPE13[3:2] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE4_WUPE13   (2U)          //!< Bit position for LLWU_PE4_WUPE13.
#define BM_LLWU_PE4_WUPE13   (0x0CU)       //!< Bit mask for LLWU_PE4_WUPE13.
#define BS_LLWU_PE4_WUPE13   (2U)          //!< Bit field size in bits for LLWU_PE4_WUPE13.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE4_WUPE13 field.
#define BR_LLWU_PE4_WUPE13   (HW_LLWU_PE4.B.WUPE13)
#endif

//! @brief Format value for bitfield LLWU_PE4_WUPE13.
#define BF_LLWU_PE4_WUPE13(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE4_WUPE13), uint8_t) & BM_LLWU_PE4_WUPE13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE13 field to a new value.
#define BW_LLWU_PE4_WUPE13(v) (HW_LLWU_PE4_WR((HW_LLWU_PE4_RD() & ~BM_LLWU_PE4_WUPE13) | BF_LLWU_PE4_WUPE13(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE4, field WUPE14[5:4] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE4_WUPE14   (4U)          //!< Bit position for LLWU_PE4_WUPE14.
#define BM_LLWU_PE4_WUPE14   (0x30U)       //!< Bit mask for LLWU_PE4_WUPE14.
#define BS_LLWU_PE4_WUPE14   (2U)          //!< Bit field size in bits for LLWU_PE4_WUPE14.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE4_WUPE14 field.
#define BR_LLWU_PE4_WUPE14   (HW_LLWU_PE4.B.WUPE14)
#endif

//! @brief Format value for bitfield LLWU_PE4_WUPE14.
#define BF_LLWU_PE4_WUPE14(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE4_WUPE14), uint8_t) & BM_LLWU_PE4_WUPE14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE14 field to a new value.
#define BW_LLWU_PE4_WUPE14(v) (HW_LLWU_PE4_WR((HW_LLWU_PE4_RD() & ~BM_LLWU_PE4_WUPE14) | BF_LLWU_PE4_WUPE14(v)))
#endif
//@}

/*!
 * @name Register LLWU_PE4, field WUPE15[7:6] (RW)
 *
 * Enables and configures the edge detection for the wakeup pin.
 *
 * Values:
 * - 00 - External input pin disabled as wakeup input
 * - 01 - External input pin enabled with rising edge detection
 * - 10 - External input pin enabled with falling edge detection
 * - 11 - External input pin enabled with any change detection
 */
//@{
#define BP_LLWU_PE4_WUPE15   (6U)          //!< Bit position for LLWU_PE4_WUPE15.
#define BM_LLWU_PE4_WUPE15   (0xC0U)       //!< Bit mask for LLWU_PE4_WUPE15.
#define BS_LLWU_PE4_WUPE15   (2U)          //!< Bit field size in bits for LLWU_PE4_WUPE15.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_PE4_WUPE15 field.
#define BR_LLWU_PE4_WUPE15   (HW_LLWU_PE4.B.WUPE15)
#endif

//! @brief Format value for bitfield LLWU_PE4_WUPE15.
#define BF_LLWU_PE4_WUPE15(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_PE4_WUPE15), uint8_t) & BM_LLWU_PE4_WUPE15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUPE15 field to a new value.
#define BW_LLWU_PE4_WUPE15(v) (HW_LLWU_PE4_WR((HW_LLWU_PE4_RD() & ~BM_LLWU_PE4_WUPE15) | BF_LLWU_PE4_WUPE15(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_ME - LLWU Module Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_ME - LLWU Module Enable register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_ME contains the bits to enable the internal module flag as a wakeup
 * input source for inputs MWUF7-MWUF0. This register is reset on Chip Reset not VLLS
 * and by reset types that trigger Chip Reset not VLLS. It is unaffected by
 * reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control Module (RCM). The
 * RCM implements many of the reset functions for the chip. See the chip's reset
 * chapter for more information. details for more information.
 */
typedef union _hw_llwu_me
{
    uint8_t U;
    struct _hw_llwu_me_bitfields
    {
        uint8_t WUME0 : 1;             //!< [0] Wakeup Module Enable For Module 0
        uint8_t WUME1 : 1;             //!< [1] Wakeup Module Enable for Module 1
        uint8_t WUME2 : 1;             //!< [2] Wakeup Module Enable For Module 2
        uint8_t WUME3 : 1;             //!< [3] Wakeup Module Enable For Module 3
        uint8_t WUME4 : 1;             //!< [4] Wakeup Module Enable For Module 4
        uint8_t WUME5 : 1;             //!< [5] Wakeup Module Enable For Module 5
        uint8_t WUME6 : 1;             //!< [6] Wakeup Module Enable For Module 6
        uint8_t WUME7 : 1;             //!< [7] Wakeup Module Enable For Module 7
    } B;
} hw_llwu_me_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_ME register
 */
//@{
#define HW_LLWU_ME_ADDR          (REGS_LLWU_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_ME               (*(__IO hw_llwu_me_t *) HW_LLWU_ME_ADDR)
#define HW_LLWU_ME_RD()          (HW_LLWU_ME.U)
#define HW_LLWU_ME_WR(v)         (HW_LLWU_ME.U = (v))
#define HW_LLWU_ME_SET(v)        (HW_LLWU_ME_WR(HW_LLWU_ME_RD() |  (v)))
#define HW_LLWU_ME_CLR(v)        (HW_LLWU_ME_WR(HW_LLWU_ME_RD() & ~(v)))
#define HW_LLWU_ME_TOG(v)        (HW_LLWU_ME_WR(HW_LLWU_ME_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_ME bitfields
 */

/*!
 * @name Register LLWU_ME, field WUME0[0] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME0     (0U)          //!< Bit position for LLWU_ME_WUME0.
#define BM_LLWU_ME_WUME0     (0x01U)       //!< Bit mask for LLWU_ME_WUME0.
#define BS_LLWU_ME_WUME0     (1U)          //!< Bit field size in bits for LLWU_ME_WUME0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME0 field.
#define BR_LLWU_ME_WUME0     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME0))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME0.
#define BF_LLWU_ME_WUME0(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME0), uint8_t) & BM_LLWU_ME_WUME0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME0 field to a new value.
#define BW_LLWU_ME_WUME0(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME0) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME1[1] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME1     (1U)          //!< Bit position for LLWU_ME_WUME1.
#define BM_LLWU_ME_WUME1     (0x02U)       //!< Bit mask for LLWU_ME_WUME1.
#define BS_LLWU_ME_WUME1     (1U)          //!< Bit field size in bits for LLWU_ME_WUME1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME1 field.
#define BR_LLWU_ME_WUME1     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME1))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME1.
#define BF_LLWU_ME_WUME1(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME1), uint8_t) & BM_LLWU_ME_WUME1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME1 field to a new value.
#define BW_LLWU_ME_WUME1(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME1) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME2[2] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME2     (2U)          //!< Bit position for LLWU_ME_WUME2.
#define BM_LLWU_ME_WUME2     (0x04U)       //!< Bit mask for LLWU_ME_WUME2.
#define BS_LLWU_ME_WUME2     (1U)          //!< Bit field size in bits for LLWU_ME_WUME2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME2 field.
#define BR_LLWU_ME_WUME2     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME2))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME2.
#define BF_LLWU_ME_WUME2(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME2), uint8_t) & BM_LLWU_ME_WUME2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME2 field to a new value.
#define BW_LLWU_ME_WUME2(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME2) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME3[3] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME3     (3U)          //!< Bit position for LLWU_ME_WUME3.
#define BM_LLWU_ME_WUME3     (0x08U)       //!< Bit mask for LLWU_ME_WUME3.
#define BS_LLWU_ME_WUME3     (1U)          //!< Bit field size in bits for LLWU_ME_WUME3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME3 field.
#define BR_LLWU_ME_WUME3     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME3))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME3.
#define BF_LLWU_ME_WUME3(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME3), uint8_t) & BM_LLWU_ME_WUME3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME3 field to a new value.
#define BW_LLWU_ME_WUME3(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME3) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME4[4] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME4     (4U)          //!< Bit position for LLWU_ME_WUME4.
#define BM_LLWU_ME_WUME4     (0x10U)       //!< Bit mask for LLWU_ME_WUME4.
#define BS_LLWU_ME_WUME4     (1U)          //!< Bit field size in bits for LLWU_ME_WUME4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME4 field.
#define BR_LLWU_ME_WUME4     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME4))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME4.
#define BF_LLWU_ME_WUME4(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME4), uint8_t) & BM_LLWU_ME_WUME4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME4 field to a new value.
#define BW_LLWU_ME_WUME4(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME4) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME5[5] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME5     (5U)          //!< Bit position for LLWU_ME_WUME5.
#define BM_LLWU_ME_WUME5     (0x20U)       //!< Bit mask for LLWU_ME_WUME5.
#define BS_LLWU_ME_WUME5     (1U)          //!< Bit field size in bits for LLWU_ME_WUME5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME5 field.
#define BR_LLWU_ME_WUME5     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME5))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME5.
#define BF_LLWU_ME_WUME5(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME5), uint8_t) & BM_LLWU_ME_WUME5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME5 field to a new value.
#define BW_LLWU_ME_WUME5(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME5) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME6[6] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME6     (6U)          //!< Bit position for LLWU_ME_WUME6.
#define BM_LLWU_ME_WUME6     (0x40U)       //!< Bit mask for LLWU_ME_WUME6.
#define BS_LLWU_ME_WUME6     (1U)          //!< Bit field size in bits for LLWU_ME_WUME6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME6 field.
#define BR_LLWU_ME_WUME6     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME6))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME6.
#define BF_LLWU_ME_WUME6(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME6), uint8_t) & BM_LLWU_ME_WUME6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME6 field to a new value.
#define BW_LLWU_ME_WUME6(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME6) = (v))
#endif
//@}

/*!
 * @name Register LLWU_ME, field WUME7[7] (RW)
 *
 * Enables an internal module as a wakeup source input.
 *
 * Values:
 * - 0 - Internal module flag not used as wakeup source
 * - 1 - Internal module flag used as wakeup source
 */
//@{
#define BP_LLWU_ME_WUME7     (7U)          //!< Bit position for LLWU_ME_WUME7.
#define BM_LLWU_ME_WUME7     (0x80U)       //!< Bit mask for LLWU_ME_WUME7.
#define BS_LLWU_ME_WUME7     (1U)          //!< Bit field size in bits for LLWU_ME_WUME7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_ME_WUME7 field.
#define BR_LLWU_ME_WUME7     (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME7))
#endif

//! @brief Format value for bitfield LLWU_ME_WUME7.
#define BF_LLWU_ME_WUME7(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_ME_WUME7), uint8_t) & BM_LLWU_ME_WUME7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUME7 field to a new value.
#define BW_LLWU_ME_WUME7(v)  (BITBAND_ACCESS8(HW_LLWU_ME_ADDR, BP_LLWU_ME_WUME7) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_F1 - LLWU Flag 1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_F1 - LLWU Flag 1 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F1 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_f1
{
    uint8_t U;
    struct _hw_llwu_f1_bitfields
    {
        uint8_t WUF0 : 1;              //!< [0] Wakeup Flag For LLWU_P0
        uint8_t WUF1 : 1;              //!< [1] Wakeup Flag For LLWU_P1
        uint8_t WUF2 : 1;              //!< [2] Wakeup Flag For LLWU_P2
        uint8_t WUF3 : 1;              //!< [3] Wakeup Flag For LLWU_P3
        uint8_t WUF4 : 1;              //!< [4] Wakeup Flag For LLWU_P4
        uint8_t WUF5 : 1;              //!< [5] Wakeup Flag For LLWU_P5
        uint8_t WUF6 : 1;              //!< [6] Wakeup Flag For LLWU_P6
        uint8_t WUF7 : 1;              //!< [7] Wakeup Flag For LLWU_P7
    } B;
} hw_llwu_f1_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_F1 register
 */
//@{
#define HW_LLWU_F1_ADDR          (REGS_LLWU_BASE + 0x5U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_F1               (*(__IO hw_llwu_f1_t *) HW_LLWU_F1_ADDR)
#define HW_LLWU_F1_RD()          (HW_LLWU_F1.U)
#define HW_LLWU_F1_WR(v)         (HW_LLWU_F1.U = (v))
#define HW_LLWU_F1_SET(v)        (HW_LLWU_F1_WR(HW_LLWU_F1_RD() |  (v)))
#define HW_LLWU_F1_CLR(v)        (HW_LLWU_F1_WR(HW_LLWU_F1_RD() & ~(v)))
#define HW_LLWU_F1_TOG(v)        (HW_LLWU_F1_WR(HW_LLWU_F1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_F1 bitfields
 */

/*!
 * @name Register LLWU_F1, field WUF0[0] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF0.
 *
 * Values:
 * - 0 - LLWU_P0 input was not a wakeup source
 * - 1 - LLWU_P0 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF0      (0U)          //!< Bit position for LLWU_F1_WUF0.
#define BM_LLWU_F1_WUF0      (0x01U)       //!< Bit mask for LLWU_F1_WUF0.
#define BS_LLWU_F1_WUF0      (1U)          //!< Bit field size in bits for LLWU_F1_WUF0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF0 field.
#define BR_LLWU_F1_WUF0      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF0))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF0.
#define BF_LLWU_F1_WUF0(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF0), uint8_t) & BM_LLWU_F1_WUF0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF0 field to a new value.
#define BW_LLWU_F1_WUF0(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF0) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF1[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF1.
 *
 * Values:
 * - 0 - LLWU_P1 input was not a wakeup source
 * - 1 - LLWU_P1 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF1      (1U)          //!< Bit position for LLWU_F1_WUF1.
#define BM_LLWU_F1_WUF1      (0x02U)       //!< Bit mask for LLWU_F1_WUF1.
#define BS_LLWU_F1_WUF1      (1U)          //!< Bit field size in bits for LLWU_F1_WUF1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF1 field.
#define BR_LLWU_F1_WUF1      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF1))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF1.
#define BF_LLWU_F1_WUF1(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF1), uint8_t) & BM_LLWU_F1_WUF1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF1 field to a new value.
#define BW_LLWU_F1_WUF1(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF1) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF2[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF2.
 *
 * Values:
 * - 0 - LLWU_P2 input was not a wakeup source
 * - 1 - LLWU_P2 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF2      (2U)          //!< Bit position for LLWU_F1_WUF2.
#define BM_LLWU_F1_WUF2      (0x04U)       //!< Bit mask for LLWU_F1_WUF2.
#define BS_LLWU_F1_WUF2      (1U)          //!< Bit field size in bits for LLWU_F1_WUF2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF2 field.
#define BR_LLWU_F1_WUF2      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF2))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF2.
#define BF_LLWU_F1_WUF2(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF2), uint8_t) & BM_LLWU_F1_WUF2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF2 field to a new value.
#define BW_LLWU_F1_WUF2(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF2) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF3[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF3.
 *
 * Values:
 * - 0 - LLWU_P3 input was not a wake-up source
 * - 1 - LLWU_P3 input was a wake-up source
 */
//@{
#define BP_LLWU_F1_WUF3      (3U)          //!< Bit position for LLWU_F1_WUF3.
#define BM_LLWU_F1_WUF3      (0x08U)       //!< Bit mask for LLWU_F1_WUF3.
#define BS_LLWU_F1_WUF3      (1U)          //!< Bit field size in bits for LLWU_F1_WUF3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF3 field.
#define BR_LLWU_F1_WUF3      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF3))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF3.
#define BF_LLWU_F1_WUF3(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF3), uint8_t) & BM_LLWU_F1_WUF3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF3 field to a new value.
#define BW_LLWU_F1_WUF3(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF3) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF4[4] (W1C)
 *
 * Indicates that an enabled external wake-up pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF4.
 *
 * Values:
 * - 0 - LLWU_P4 input was not a wakeup source
 * - 1 - LLWU_P4 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF4      (4U)          //!< Bit position for LLWU_F1_WUF4.
#define BM_LLWU_F1_WUF4      (0x10U)       //!< Bit mask for LLWU_F1_WUF4.
#define BS_LLWU_F1_WUF4      (1U)          //!< Bit field size in bits for LLWU_F1_WUF4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF4 field.
#define BR_LLWU_F1_WUF4      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF4))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF4.
#define BF_LLWU_F1_WUF4(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF4), uint8_t) & BM_LLWU_F1_WUF4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF4 field to a new value.
#define BW_LLWU_F1_WUF4(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF4) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF5[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF5.
 *
 * Values:
 * - 0 - LLWU_P5 input was not a wakeup source
 * - 1 - LLWU_P5 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF5      (5U)          //!< Bit position for LLWU_F1_WUF5.
#define BM_LLWU_F1_WUF5      (0x20U)       //!< Bit mask for LLWU_F1_WUF5.
#define BS_LLWU_F1_WUF5      (1U)          //!< Bit field size in bits for LLWU_F1_WUF5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF5 field.
#define BR_LLWU_F1_WUF5      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF5))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF5.
#define BF_LLWU_F1_WUF5(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF5), uint8_t) & BM_LLWU_F1_WUF5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF5 field to a new value.
#define BW_LLWU_F1_WUF5(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF5) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF6[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF6.
 *
 * Values:
 * - 0 - LLWU_P6 input was not a wakeup source
 * - 1 - LLWU_P6 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF6      (6U)          //!< Bit position for LLWU_F1_WUF6.
#define BM_LLWU_F1_WUF6      (0x40U)       //!< Bit mask for LLWU_F1_WUF6.
#define BS_LLWU_F1_WUF6      (1U)          //!< Bit field size in bits for LLWU_F1_WUF6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF6 field.
#define BR_LLWU_F1_WUF6      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF6))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF6.
#define BF_LLWU_F1_WUF6(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF6), uint8_t) & BM_LLWU_F1_WUF6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF6 field to a new value.
#define BW_LLWU_F1_WUF6(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF6) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F1, field WUF7[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF7.
 *
 * Values:
 * - 0 - LLWU_P7 input was not a wakeup source
 * - 1 - LLWU_P7 input was a wakeup source
 */
//@{
#define BP_LLWU_F1_WUF7      (7U)          //!< Bit position for LLWU_F1_WUF7.
#define BM_LLWU_F1_WUF7      (0x80U)       //!< Bit mask for LLWU_F1_WUF7.
#define BS_LLWU_F1_WUF7      (1U)          //!< Bit field size in bits for LLWU_F1_WUF7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F1_WUF7 field.
#define BR_LLWU_F1_WUF7      (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF7))
#endif

//! @brief Format value for bitfield LLWU_F1_WUF7.
#define BF_LLWU_F1_WUF7(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F1_WUF7), uint8_t) & BM_LLWU_F1_WUF7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF7 field to a new value.
#define BW_LLWU_F1_WUF7(v)   (BITBAND_ACCESS8(HW_LLWU_F1_ADDR, BP_LLWU_F1_WUF7) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_F2 - LLWU Flag 2 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_F2 - LLWU Flag 2 register (W1C)
 *
 * Reset value: 0x00U
 *
 * LLWU_F2 contains the wakeup flags indicating which wakeup source caused the
 * MCU to exit LLS or VLLS mode. For LLS, this is the source causing the CPU
 * interrupt flow. For VLLS, this is the source causing the MCU reset flow. The
 * external wakeup flags are read-only and clearing a flag is accomplished by a write
 * of a 1 to the corresponding WUFx bit. The wakeup flag (WUFx), if set, will
 * remain set if the associated WUPEx bit is cleared. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_f2
{
    uint8_t U;
    struct _hw_llwu_f2_bitfields
    {
        uint8_t WUF8 : 1;              //!< [0] Wakeup Flag For LLWU_P8
        uint8_t WUF9 : 1;              //!< [1] Wakeup Flag For LLWU_P9
        uint8_t WUF10 : 1;             //!< [2] Wakeup Flag For LLWU_P10
        uint8_t WUF11 : 1;             //!< [3] Wakeup Flag For LLWU_P11
        uint8_t WUF12 : 1;             //!< [4] Wakeup Flag For LLWU_P12
        uint8_t WUF13 : 1;             //!< [5] Wakeup Flag For LLWU_P13
        uint8_t WUF14 : 1;             //!< [6] Wakeup Flag For LLWU_P14
        uint8_t WUF15 : 1;             //!< [7] Wakeup Flag For LLWU_P15
    } B;
} hw_llwu_f2_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_F2 register
 */
//@{
#define HW_LLWU_F2_ADDR          (REGS_LLWU_BASE + 0x6U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_F2               (*(__IO hw_llwu_f2_t *) HW_LLWU_F2_ADDR)
#define HW_LLWU_F2_RD()          (HW_LLWU_F2.U)
#define HW_LLWU_F2_WR(v)         (HW_LLWU_F2.U = (v))
#define HW_LLWU_F2_SET(v)        (HW_LLWU_F2_WR(HW_LLWU_F2_RD() |  (v)))
#define HW_LLWU_F2_CLR(v)        (HW_LLWU_F2_WR(HW_LLWU_F2_RD() & ~(v)))
#define HW_LLWU_F2_TOG(v)        (HW_LLWU_F2_WR(HW_LLWU_F2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_F2 bitfields
 */

/*!
 * @name Register LLWU_F2, field WUF8[0] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF8.
 *
 * Values:
 * - 0 - LLWU_P8 input was not a wakeup source
 * - 1 - LLWU_P8 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF8      (0U)          //!< Bit position for LLWU_F2_WUF8.
#define BM_LLWU_F2_WUF8      (0x01U)       //!< Bit mask for LLWU_F2_WUF8.
#define BS_LLWU_F2_WUF8      (1U)          //!< Bit field size in bits for LLWU_F2_WUF8.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF8 field.
#define BR_LLWU_F2_WUF8      (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF8))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF8.
#define BF_LLWU_F2_WUF8(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF8), uint8_t) & BM_LLWU_F2_WUF8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF8 field to a new value.
#define BW_LLWU_F2_WUF8(v)   (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF8) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF9[1] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF9.
 *
 * Values:
 * - 0 - LLWU_P9 input was not a wakeup source
 * - 1 - LLWU_P9 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF9      (1U)          //!< Bit position for LLWU_F2_WUF9.
#define BM_LLWU_F2_WUF9      (0x02U)       //!< Bit mask for LLWU_F2_WUF9.
#define BS_LLWU_F2_WUF9      (1U)          //!< Bit field size in bits for LLWU_F2_WUF9.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF9 field.
#define BR_LLWU_F2_WUF9      (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF9))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF9.
#define BF_LLWU_F2_WUF9(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF9), uint8_t) & BM_LLWU_F2_WUF9)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF9 field to a new value.
#define BW_LLWU_F2_WUF9(v)   (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF9) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF10[2] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF10.
 *
 * Values:
 * - 0 - LLWU_P10 input was not a wakeup source
 * - 1 - LLWU_P10 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF10     (2U)          //!< Bit position for LLWU_F2_WUF10.
#define BM_LLWU_F2_WUF10     (0x04U)       //!< Bit mask for LLWU_F2_WUF10.
#define BS_LLWU_F2_WUF10     (1U)          //!< Bit field size in bits for LLWU_F2_WUF10.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF10 field.
#define BR_LLWU_F2_WUF10     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF10))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF10.
#define BF_LLWU_F2_WUF10(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF10), uint8_t) & BM_LLWU_F2_WUF10)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF10 field to a new value.
#define BW_LLWU_F2_WUF10(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF10) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF11[3] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF11.
 *
 * Values:
 * - 0 - LLWU_P11 input was not a wakeup source
 * - 1 - LLWU_P11 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF11     (3U)          //!< Bit position for LLWU_F2_WUF11.
#define BM_LLWU_F2_WUF11     (0x08U)       //!< Bit mask for LLWU_F2_WUF11.
#define BS_LLWU_F2_WUF11     (1U)          //!< Bit field size in bits for LLWU_F2_WUF11.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF11 field.
#define BR_LLWU_F2_WUF11     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF11))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF11.
#define BF_LLWU_F2_WUF11(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF11), uint8_t) & BM_LLWU_F2_WUF11)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF11 field to a new value.
#define BW_LLWU_F2_WUF11(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF11) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF12[4] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF12.
 *
 * Values:
 * - 0 - LLWU_P12 input was not a wakeup source
 * - 1 - LLWU_P12 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF12     (4U)          //!< Bit position for LLWU_F2_WUF12.
#define BM_LLWU_F2_WUF12     (0x10U)       //!< Bit mask for LLWU_F2_WUF12.
#define BS_LLWU_F2_WUF12     (1U)          //!< Bit field size in bits for LLWU_F2_WUF12.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF12 field.
#define BR_LLWU_F2_WUF12     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF12))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF12.
#define BF_LLWU_F2_WUF12(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF12), uint8_t) & BM_LLWU_F2_WUF12)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF12 field to a new value.
#define BW_LLWU_F2_WUF12(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF12) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF13[5] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF13.
 *
 * Values:
 * - 0 - LLWU_P13 input was not a wakeup source
 * - 1 - LLWU_P13 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF13     (5U)          //!< Bit position for LLWU_F2_WUF13.
#define BM_LLWU_F2_WUF13     (0x20U)       //!< Bit mask for LLWU_F2_WUF13.
#define BS_LLWU_F2_WUF13     (1U)          //!< Bit field size in bits for LLWU_F2_WUF13.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF13 field.
#define BR_LLWU_F2_WUF13     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF13))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF13.
#define BF_LLWU_F2_WUF13(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF13), uint8_t) & BM_LLWU_F2_WUF13)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF13 field to a new value.
#define BW_LLWU_F2_WUF13(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF13) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF14[6] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF14.
 *
 * Values:
 * - 0 - LLWU_P14 input was not a wakeup source
 * - 1 - LLWU_P14 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF14     (6U)          //!< Bit position for LLWU_F2_WUF14.
#define BM_LLWU_F2_WUF14     (0x40U)       //!< Bit mask for LLWU_F2_WUF14.
#define BS_LLWU_F2_WUF14     (1U)          //!< Bit field size in bits for LLWU_F2_WUF14.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF14 field.
#define BR_LLWU_F2_WUF14     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF14))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF14.
#define BF_LLWU_F2_WUF14(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF14), uint8_t) & BM_LLWU_F2_WUF14)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF14 field to a new value.
#define BW_LLWU_F2_WUF14(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF14) = (v))
#endif
//@}

/*!
 * @name Register LLWU_F2, field WUF15[7] (W1C)
 *
 * Indicates that an enabled external wakeup pin was a source of exiting a
 * low-leakage power mode. To clear the flag, write a 1 to WUF15.
 *
 * Values:
 * - 0 - LLWU_P15 input was not a wakeup source
 * - 1 - LLWU_P15 input was a wakeup source
 */
//@{
#define BP_LLWU_F2_WUF15     (7U)          //!< Bit position for LLWU_F2_WUF15.
#define BM_LLWU_F2_WUF15     (0x80U)       //!< Bit mask for LLWU_F2_WUF15.
#define BS_LLWU_F2_WUF15     (1U)          //!< Bit field size in bits for LLWU_F2_WUF15.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F2_WUF15 field.
#define BR_LLWU_F2_WUF15     (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF15))
#endif

//! @brief Format value for bitfield LLWU_F2_WUF15.
#define BF_LLWU_F2_WUF15(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_F2_WUF15), uint8_t) & BM_LLWU_F2_WUF15)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUF15 field to a new value.
#define BW_LLWU_F2_WUF15(v)  (BITBAND_ACCESS8(HW_LLWU_F2_ADDR, BP_LLWU_F2_WUF15) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_F3 - LLWU Flag 3 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_F3 - LLWU Flag 3 register (RO)
 *
 * Reset value: 0x00U
 *
 * LLWU_F3 contains the wakeup flags indicating which internal wakeup source
 * caused the MCU to exit LLS or VLLS mode. For LLS, this is the source causing the
 * CPU interrupt flow. For VLLS, this is the source causing the MCU reset flow.
 * For internal peripherals that are capable of running in a low-leakage power
 * mode, such as a real time clock module or CMP module, the flag from the
 * associated peripheral is accessible as the MWUFx bit. The flag will need to be cleared
 * in the peripheral instead of writing a 1 to the MWUFx bit. This register is
 * reset on Chip Reset not VLLS and by reset types that trigger Chip Reset not
 * VLLS. It is unaffected by reset types that do not trigger Chip Reset not VLLS. See
 * the IntroductionInformation found here describes the registers of the Reset
 * Control Module (RCM). The RCM implements many of the reset functions for the
 * chip. See the chip's reset chapter for more information. details for more
 * information.
 */
typedef union _hw_llwu_f3
{
    uint8_t U;
    struct _hw_llwu_f3_bitfields
    {
        uint8_t MWUF0 : 1;             //!< [0] Wakeup flag For module 0
        uint8_t MWUF1 : 1;             //!< [1] Wakeup flag For module 1
        uint8_t MWUF2 : 1;             //!< [2] Wakeup flag For module 2
        uint8_t MWUF3 : 1;             //!< [3] Wakeup flag For module 3
        uint8_t MWUF4 : 1;             //!< [4] Wakeup flag For module 4
        uint8_t MWUF5 : 1;             //!< [5] Wakeup flag For module 5
        uint8_t MWUF6 : 1;             //!< [6] Wakeup flag For module 6
        uint8_t MWUF7 : 1;             //!< [7] Wakeup flag For module 7
    } B;
} hw_llwu_f3_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_F3 register
 */
//@{
#define HW_LLWU_F3_ADDR          (REGS_LLWU_BASE + 0x7U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_F3               (*(__I hw_llwu_f3_t *) HW_LLWU_F3_ADDR)
#define HW_LLWU_F3_RD()          (HW_LLWU_F3.U)
#endif
//@}

/*
 * Constants & macros for individual LLWU_F3 bitfields
 */

/*!
 * @name Register LLWU_F3, field MWUF0[0] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 0 input was not a wakeup source
 * - 1 - Module 0 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF0     (0U)          //!< Bit position for LLWU_F3_MWUF0.
#define BM_LLWU_F3_MWUF0     (0x01U)       //!< Bit mask for LLWU_F3_MWUF0.
#define BS_LLWU_F3_MWUF0     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF0 field.
#define BR_LLWU_F3_MWUF0     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF0))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF1[1] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 1 input was not a wakeup source
 * - 1 - Module 1 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF1     (1U)          //!< Bit position for LLWU_F3_MWUF1.
#define BM_LLWU_F3_MWUF1     (0x02U)       //!< Bit mask for LLWU_F3_MWUF1.
#define BS_LLWU_F3_MWUF1     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF1 field.
#define BR_LLWU_F3_MWUF1     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF1))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF2[2] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 2 input was not a wakeup source
 * - 1 - Module 2 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF2     (2U)          //!< Bit position for LLWU_F3_MWUF2.
#define BM_LLWU_F3_MWUF2     (0x04U)       //!< Bit mask for LLWU_F3_MWUF2.
#define BS_LLWU_F3_MWUF2     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF2 field.
#define BR_LLWU_F3_MWUF2     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF2))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF3[3] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 3 input was not a wakeup source
 * - 1 - Module 3 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF3     (3U)          //!< Bit position for LLWU_F3_MWUF3.
#define BM_LLWU_F3_MWUF3     (0x08U)       //!< Bit mask for LLWU_F3_MWUF3.
#define BS_LLWU_F3_MWUF3     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF3 field.
#define BR_LLWU_F3_MWUF3     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF3))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF4[4] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 4 input was not a wakeup source
 * - 1 - Module 4 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF4     (4U)          //!< Bit position for LLWU_F3_MWUF4.
#define BM_LLWU_F3_MWUF4     (0x10U)       //!< Bit mask for LLWU_F3_MWUF4.
#define BS_LLWU_F3_MWUF4     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF4 field.
#define BR_LLWU_F3_MWUF4     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF4))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF5[5] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 5 input was not a wakeup source
 * - 1 - Module 5 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF5     (5U)          //!< Bit position for LLWU_F3_MWUF5.
#define BM_LLWU_F3_MWUF5     (0x20U)       //!< Bit mask for LLWU_F3_MWUF5.
#define BS_LLWU_F3_MWUF5     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF5 field.
#define BR_LLWU_F3_MWUF5     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF5))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF6[6] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 6 input was not a wakeup source
 * - 1 - Module 6 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF6     (6U)          //!< Bit position for LLWU_F3_MWUF6.
#define BM_LLWU_F3_MWUF6     (0x40U)       //!< Bit mask for LLWU_F3_MWUF6.
#define BS_LLWU_F3_MWUF6     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF6 field.
#define BR_LLWU_F3_MWUF6     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF6))
#endif
//@}

/*!
 * @name Register LLWU_F3, field MWUF7[7] (RO)
 *
 * Indicates that an enabled internal peripheral was a source of exiting a
 * low-leakage power mode. To clear the flag, follow the internal peripheral flag
 * clearing mechanism.
 *
 * Values:
 * - 0 - Module 7 input was not a wakeup source
 * - 1 - Module 7 input was a wakeup source
 */
//@{
#define BP_LLWU_F3_MWUF7     (7U)          //!< Bit position for LLWU_F3_MWUF7.
#define BM_LLWU_F3_MWUF7     (0x80U)       //!< Bit mask for LLWU_F3_MWUF7.
#define BS_LLWU_F3_MWUF7     (1U)          //!< Bit field size in bits for LLWU_F3_MWUF7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_F3_MWUF7 field.
#define BR_LLWU_F3_MWUF7     (BITBAND_ACCESS8(HW_LLWU_F3_ADDR, BP_LLWU_F3_MWUF7))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_FILT1 - LLWU Pin Filter 1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_FILT1 - LLWU Pin Filter 1 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT1 is a control and status register that is used to enable/disable
 * the digital filter 1 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_filt1
{
    uint8_t U;
    struct _hw_llwu_filt1_bitfields
    {
        uint8_t FILTSEL : 4;           //!< [3:0] Filter Pin Select
        uint8_t RESERVED0 : 1;         //!< [4]
        uint8_t FILTE : 2;             //!< [6:5] Digital Filter On External Pin
        uint8_t FILTF : 1;             //!< [7] Filter Detect Flag
    } B;
} hw_llwu_filt1_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_FILT1 register
 */
//@{
#define HW_LLWU_FILT1_ADDR       (REGS_LLWU_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_FILT1            (*(__IO hw_llwu_filt1_t *) HW_LLWU_FILT1_ADDR)
#define HW_LLWU_FILT1_RD()       (HW_LLWU_FILT1.U)
#define HW_LLWU_FILT1_WR(v)      (HW_LLWU_FILT1.U = (v))
#define HW_LLWU_FILT1_SET(v)     (HW_LLWU_FILT1_WR(HW_LLWU_FILT1_RD() |  (v)))
#define HW_LLWU_FILT1_CLR(v)     (HW_LLWU_FILT1_WR(HW_LLWU_FILT1_RD() & ~(v)))
#define HW_LLWU_FILT1_TOG(v)     (HW_LLWU_FILT1_WR(HW_LLWU_FILT1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_FILT1 bitfields
 */

/*!
 * @name Register LLWU_FILT1, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
//@{
#define BP_LLWU_FILT1_FILTSEL (0U)         //!< Bit position for LLWU_FILT1_FILTSEL.
#define BM_LLWU_FILT1_FILTSEL (0x0FU)      //!< Bit mask for LLWU_FILT1_FILTSEL.
#define BS_LLWU_FILT1_FILTSEL (4U)         //!< Bit field size in bits for LLWU_FILT1_FILTSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT1_FILTSEL field.
#define BR_LLWU_FILT1_FILTSEL (HW_LLWU_FILT1.B.FILTSEL)
#endif

//! @brief Format value for bitfield LLWU_FILT1_FILTSEL.
#define BF_LLWU_FILT1_FILTSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT1_FILTSEL), uint8_t) & BM_LLWU_FILT1_FILTSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTSEL field to a new value.
#define BW_LLWU_FILT1_FILTSEL(v) (HW_LLWU_FILT1_WR((HW_LLWU_FILT1_RD() & ~BM_LLWU_FILT1_FILTSEL) | BF_LLWU_FILT1_FILTSEL(v)))
#endif
//@}

/*!
 * @name Register LLWU_FILT1, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
//@{
#define BP_LLWU_FILT1_FILTE  (5U)          //!< Bit position for LLWU_FILT1_FILTE.
#define BM_LLWU_FILT1_FILTE  (0x60U)       //!< Bit mask for LLWU_FILT1_FILTE.
#define BS_LLWU_FILT1_FILTE  (2U)          //!< Bit field size in bits for LLWU_FILT1_FILTE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT1_FILTE field.
#define BR_LLWU_FILT1_FILTE  (HW_LLWU_FILT1.B.FILTE)
#endif

//! @brief Format value for bitfield LLWU_FILT1_FILTE.
#define BF_LLWU_FILT1_FILTE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT1_FILTE), uint8_t) & BM_LLWU_FILT1_FILTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTE field to a new value.
#define BW_LLWU_FILT1_FILTE(v) (HW_LLWU_FILT1_WR((HW_LLWU_FILT1_RD() & ~BM_LLWU_FILT1_FILTE) | BF_LLWU_FILT1_FILTE(v)))
#endif
//@}

/*!
 * @name Register LLWU_FILT1, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 1 was not a wakeup source
 * - 1 - Pin Filter 1 was a wakeup source
 */
//@{
#define BP_LLWU_FILT1_FILTF  (7U)          //!< Bit position for LLWU_FILT1_FILTF.
#define BM_LLWU_FILT1_FILTF  (0x80U)       //!< Bit mask for LLWU_FILT1_FILTF.
#define BS_LLWU_FILT1_FILTF  (1U)          //!< Bit field size in bits for LLWU_FILT1_FILTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT1_FILTF field.
#define BR_LLWU_FILT1_FILTF  (BITBAND_ACCESS8(HW_LLWU_FILT1_ADDR, BP_LLWU_FILT1_FILTF))
#endif

//! @brief Format value for bitfield LLWU_FILT1_FILTF.
#define BF_LLWU_FILT1_FILTF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT1_FILTF), uint8_t) & BM_LLWU_FILT1_FILTF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTF field to a new value.
#define BW_LLWU_FILT1_FILTF(v) (BITBAND_ACCESS8(HW_LLWU_FILT1_ADDR, BP_LLWU_FILT1_FILTF) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_FILT2 - LLWU Pin Filter 2 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_FILT2 - LLWU Pin Filter 2 register (RW)
 *
 * Reset value: 0x00U
 *
 * LLWU_FILT2 is a control and status register that is used to enable/disable
 * the digital filter 2 features for an external pin. This register is reset on
 * Chip Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See
 * the chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_filt2
{
    uint8_t U;
    struct _hw_llwu_filt2_bitfields
    {
        uint8_t FILTSEL : 4;           //!< [3:0] Filter Pin Select
        uint8_t RESERVED0 : 1;         //!< [4]
        uint8_t FILTE : 2;             //!< [6:5] Digital Filter On External Pin
        uint8_t FILTF : 1;             //!< [7] Filter Detect Flag
    } B;
} hw_llwu_filt2_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_FILT2 register
 */
//@{
#define HW_LLWU_FILT2_ADDR       (REGS_LLWU_BASE + 0x9U)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_FILT2            (*(__IO hw_llwu_filt2_t *) HW_LLWU_FILT2_ADDR)
#define HW_LLWU_FILT2_RD()       (HW_LLWU_FILT2.U)
#define HW_LLWU_FILT2_WR(v)      (HW_LLWU_FILT2.U = (v))
#define HW_LLWU_FILT2_SET(v)     (HW_LLWU_FILT2_WR(HW_LLWU_FILT2_RD() |  (v)))
#define HW_LLWU_FILT2_CLR(v)     (HW_LLWU_FILT2_WR(HW_LLWU_FILT2_RD() & ~(v)))
#define HW_LLWU_FILT2_TOG(v)     (HW_LLWU_FILT2_WR(HW_LLWU_FILT2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_FILT2 bitfields
 */

/*!
 * @name Register LLWU_FILT2, field FILTSEL[3:0] (RW)
 *
 * Selects 1 out of the 16 wakeup pins to be muxed into the filter.
 *
 * Values:
 * - 0000 - Select LLWU_P0 for filter
 * - 1111 - Select LLWU_P15 for filter
 */
//@{
#define BP_LLWU_FILT2_FILTSEL (0U)         //!< Bit position for LLWU_FILT2_FILTSEL.
#define BM_LLWU_FILT2_FILTSEL (0x0FU)      //!< Bit mask for LLWU_FILT2_FILTSEL.
#define BS_LLWU_FILT2_FILTSEL (4U)         //!< Bit field size in bits for LLWU_FILT2_FILTSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT2_FILTSEL field.
#define BR_LLWU_FILT2_FILTSEL (HW_LLWU_FILT2.B.FILTSEL)
#endif

//! @brief Format value for bitfield LLWU_FILT2_FILTSEL.
#define BF_LLWU_FILT2_FILTSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT2_FILTSEL), uint8_t) & BM_LLWU_FILT2_FILTSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTSEL field to a new value.
#define BW_LLWU_FILT2_FILTSEL(v) (HW_LLWU_FILT2_WR((HW_LLWU_FILT2_RD() & ~BM_LLWU_FILT2_FILTSEL) | BF_LLWU_FILT2_FILTSEL(v)))
#endif
//@}

/*!
 * @name Register LLWU_FILT2, field FILTE[6:5] (RW)
 *
 * Controls the digital filter options for the external pin detect.
 *
 * Values:
 * - 00 - Filter disabled
 * - 01 - Filter posedge detect enabled
 * - 10 - Filter negedge detect enabled
 * - 11 - Filter any edge detect enabled
 */
//@{
#define BP_LLWU_FILT2_FILTE  (5U)          //!< Bit position for LLWU_FILT2_FILTE.
#define BM_LLWU_FILT2_FILTE  (0x60U)       //!< Bit mask for LLWU_FILT2_FILTE.
#define BS_LLWU_FILT2_FILTE  (2U)          //!< Bit field size in bits for LLWU_FILT2_FILTE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT2_FILTE field.
#define BR_LLWU_FILT2_FILTE  (HW_LLWU_FILT2.B.FILTE)
#endif

//! @brief Format value for bitfield LLWU_FILT2_FILTE.
#define BF_LLWU_FILT2_FILTE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT2_FILTE), uint8_t) & BM_LLWU_FILT2_FILTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTE field to a new value.
#define BW_LLWU_FILT2_FILTE(v) (HW_LLWU_FILT2_WR((HW_LLWU_FILT2_RD() & ~BM_LLWU_FILT2_FILTE) | BF_LLWU_FILT2_FILTE(v)))
#endif
//@}

/*!
 * @name Register LLWU_FILT2, field FILTF[7] (W1C)
 *
 * Indicates that the filtered external wakeup pin, selected by FILTSEL, was a
 * source of exiting a low-leakage power mode. To clear the flag write a one to
 * FILTF.
 *
 * Values:
 * - 0 - Pin Filter 2 was not a wakeup source
 * - 1 - Pin Filter 2 was a wakeup source
 */
//@{
#define BP_LLWU_FILT2_FILTF  (7U)          //!< Bit position for LLWU_FILT2_FILTF.
#define BM_LLWU_FILT2_FILTF  (0x80U)       //!< Bit mask for LLWU_FILT2_FILTF.
#define BS_LLWU_FILT2_FILTF  (1U)          //!< Bit field size in bits for LLWU_FILT2_FILTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_FILT2_FILTF field.
#define BR_LLWU_FILT2_FILTF  (BITBAND_ACCESS8(HW_LLWU_FILT2_ADDR, BP_LLWU_FILT2_FILTF))
#endif

//! @brief Format value for bitfield LLWU_FILT2_FILTF.
#define BF_LLWU_FILT2_FILTF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_FILT2_FILTF), uint8_t) & BM_LLWU_FILT2_FILTF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FILTF field to a new value.
#define BW_LLWU_FILT2_FILTF(v) (BITBAND_ACCESS8(HW_LLWU_FILT2_ADDR, BP_LLWU_FILT2_FILTF) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_LLWU_RST - LLWU Reset Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_LLWU_RST - LLWU Reset Enable register (RW)
 *
 * Reset value: 0x02U
 *
 * LLWU_RST is a control register that is used to enable/disable the digital
 * filter for the external pin detect and RESET pin. This register is reset on Chip
 * Reset not VLLS and by reset types that trigger Chip Reset not VLLS. It is
 * unaffected by reset types that do not trigger Chip Reset not VLLS. See the
 * IntroductionInformation found here describes the registers of the Reset Control
 * Module (RCM). The RCM implements many of the reset functions for the chip. See the
 * chip's reset chapter for more information. details for more information.
 */
typedef union _hw_llwu_rst
{
    uint8_t U;
    struct _hw_llwu_rst_bitfields
    {
        uint8_t RSTFILT : 1;           //!< [0] Digital Filter On RESET Pin
        uint8_t LLRSTE : 1;            //!< [1] Low-Leakage Mode RESET Enable
        uint8_t RESERVED0 : 6;         //!< [7:2]
    } B;
} hw_llwu_rst_t;
#endif

/*!
 * @name Constants and macros for entire LLWU_RST register
 */
//@{
#define HW_LLWU_RST_ADDR         (REGS_LLWU_BASE + 0xAU)

#ifndef __LANGUAGE_ASM__
#define HW_LLWU_RST              (*(__IO hw_llwu_rst_t *) HW_LLWU_RST_ADDR)
#define HW_LLWU_RST_RD()         (HW_LLWU_RST.U)
#define HW_LLWU_RST_WR(v)        (HW_LLWU_RST.U = (v))
#define HW_LLWU_RST_SET(v)       (HW_LLWU_RST_WR(HW_LLWU_RST_RD() |  (v)))
#define HW_LLWU_RST_CLR(v)       (HW_LLWU_RST_WR(HW_LLWU_RST_RD() & ~(v)))
#define HW_LLWU_RST_TOG(v)       (HW_LLWU_RST_WR(HW_LLWU_RST_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual LLWU_RST bitfields
 */

/*!
 * @name Register LLWU_RST, field RSTFILT[0] (RW)
 *
 * Enables the digital filter for the RESET pin during LLS, VLLS3, VLLS2, or
 * VLLS1 modes.
 *
 * Values:
 * - 0 - Filter not enabled
 * - 1 - Filter enabled
 */
//@{
#define BP_LLWU_RST_RSTFILT  (0U)          //!< Bit position for LLWU_RST_RSTFILT.
#define BM_LLWU_RST_RSTFILT  (0x01U)       //!< Bit mask for LLWU_RST_RSTFILT.
#define BS_LLWU_RST_RSTFILT  (1U)          //!< Bit field size in bits for LLWU_RST_RSTFILT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_RST_RSTFILT field.
#define BR_LLWU_RST_RSTFILT  (BITBAND_ACCESS8(HW_LLWU_RST_ADDR, BP_LLWU_RST_RSTFILT))
#endif

//! @brief Format value for bitfield LLWU_RST_RSTFILT.
#define BF_LLWU_RST_RSTFILT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_RST_RSTFILT), uint8_t) & BM_LLWU_RST_RSTFILT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTFILT field to a new value.
#define BW_LLWU_RST_RSTFILT(v) (BITBAND_ACCESS8(HW_LLWU_RST_ADDR, BP_LLWU_RST_RSTFILT) = (v))
#endif
//@}

/*!
 * @name Register LLWU_RST, field LLRSTE[1] (RW)
 *
 * This bit must be set to allow the device to be reset while in a low-leakage
 * power mode. On devices where Reset is not a dedicated pin, the RESET pin must
 * also be enabled in the explicit port mux control.
 *
 * Values:
 * - 0 - RESET pin not enabled as a leakage mode exit source
 * - 1 - RESET pin enabled as a low leakage mode exit source
 */
//@{
#define BP_LLWU_RST_LLRSTE   (1U)          //!< Bit position for LLWU_RST_LLRSTE.
#define BM_LLWU_RST_LLRSTE   (0x02U)       //!< Bit mask for LLWU_RST_LLRSTE.
#define BS_LLWU_RST_LLRSTE   (1U)          //!< Bit field size in bits for LLWU_RST_LLRSTE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the LLWU_RST_LLRSTE field.
#define BR_LLWU_RST_LLRSTE   (BITBAND_ACCESS8(HW_LLWU_RST_ADDR, BP_LLWU_RST_LLRSTE))
#endif

//! @brief Format value for bitfield LLWU_RST_LLRSTE.
#define BF_LLWU_RST_LLRSTE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_LLWU_RST_LLRSTE), uint8_t) & BM_LLWU_RST_LLRSTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LLRSTE field to a new value.
#define BW_LLWU_RST_LLRSTE(v) (BITBAND_ACCESS8(HW_LLWU_RST_ADDR, BP_LLWU_RST_LLRSTE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_llwu_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All LLWU module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_llwu
{
    __IO hw_llwu_pe1_t PE1;                //!< [0x0] LLWU Pin Enable 1 register
    __IO hw_llwu_pe2_t PE2;                //!< [0x1] LLWU Pin Enable 2 register
    __IO hw_llwu_pe3_t PE3;                //!< [0x2] LLWU Pin Enable 3 register
    __IO hw_llwu_pe4_t PE4;                //!< [0x3] LLWU Pin Enable 4 register
    __IO hw_llwu_me_t ME;                  //!< [0x4] LLWU Module Enable register
    __IO hw_llwu_f1_t F1;                  //!< [0x5] LLWU Flag 1 register
    __IO hw_llwu_f2_t F2;                  //!< [0x6] LLWU Flag 2 register
    __I hw_llwu_f3_t F3;                   //!< [0x7] LLWU Flag 3 register
    __IO hw_llwu_filt1_t FILT1;            //!< [0x8] LLWU Pin Filter 1 register
    __IO hw_llwu_filt2_t FILT2;            //!< [0x9] LLWU Pin Filter 2 register
    __IO hw_llwu_rst_t RST;                //!< [0xA] LLWU Reset Enable register
} hw_llwu_t;
#pragma pack()

//! @brief Macro to access all LLWU registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_LLWU</code>.
#define HW_LLWU        (*(hw_llwu_t *) REGS_LLWU_BASE)
#endif

#endif // __HW_LLWU_REGISTERS_H__
// v22/130726/0.9
// EOF
