#define LOG_LEVEL_INFO
#include "Puck.h"

Puck* puck = &Puck::getPuck();

InterruptIn pb1(BUTTON1);
InterruptIn pb2(BUTTON2);

uint8_t currentlyPushedButton = 0;

void onButton1Pushed(void) {
    currentlyPushedButton = 1;
}

void onButton2Pushed(void) {
    currentlyPushedButton = 2;
}

void onButton3Pushed(void) {
    currentlyPushedButton = 3;
}

void onButton4Pushed(void) {
    currentlyPushedButton = 4;
}

// Sample Gatt characteristic and service UUIDs
const UUID SAMPLE_GATT_SERVICE = stringToUUID("bftj sample     ");
const UUID SAMPLE_GATT_CHARACTERISTIC = stringToUUID("bftj sample char");

int main(void) {
    
    pb1.rise(&onButton1Pushed);
    pb1.enable_irq();
    
    pb2.rise(&onButton2Pushed);
    pb2.enable_irq();
    
    
    
    // Add the Gatt characteristic
    int characteristicValueLength = 1;
    puck->addCharacteristic(
            SAMPLE_GATT_SERVICE,
            SAMPLE_GATT_CHARACTERISTIC,
            characteristicValueLength,
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);

    // Initialize the puck
    puck->init(0xFEED);

    // Set the initial value of the characteristic
    uint8_t new_value = 0;
    puck->updateCharacteristicValue(SAMPLE_GATT_CHARACTERISTIC, &new_value, characteristicValueLength);

    // Let the puck do its thing
    while(puck->drive()) { 
        if(currentlyPushedButton) {
            puck->updateCharacteristicValue(SAMPLE_GATT_CHARACTERISTIC, &currentlyPushedButton, 1);
            LOG_INFO("button: %i\n", currentlyPushedButton);
            currentlyPushedButton = 0;    
        }
    };
}