#include "motor.h"
#include "mbed.h"


Motor::Motor(PinName pwm, PinName in1, PinName in2)
    : FIn1(in1), FIn2(in2), FSpeed(pwm) 
{
        FSpeed = 0.0;
}

void Motor::Move(float speed)
{
    if (speed > 0) {
        FIn1 = 1;
        FIn2 = 0;
        FSpeed = speed;
    }
    else {
        FIn1 = 0;
        FIn2 = 1;
        FSpeed = -speed;
    }
}
 
   
      