#include "lineTrace.h"

const float ControlPeriod = 0.01;   // sec;

LineTrace trace(
    LineSensors(
        AnalogIn(P1IN), AnalogIn(P2IN), AnalogIn(P3IN), AnalogIn(P4IN)), 
    Motor( L_PWM, L_IN1, L_IN2 ),
    Motor( R_PWM, R_IN1, R_IN2 )
);
Ticker timer;

void attime()
{
    trace.Servo();
}

int main()
{
#ifdef Debug
    ReflectSensor *p1 = new ReflectSensor(AnalogIn(P1IN));
    ReflectSensor *p2 = new ReflectSensor(AnalogIn(P2IN));
    ReflectSensor *p3 = new ReflectSensor(AnalogIn(P3IN));
    ReflectSensor *p4 = new ReflectSensor(AnalogIn(P4IN));

    LineSensors *psens = new LineSensors(
                            ReflectSensor(AnalogIn(P1IN)),
                            ReflectSensor(AnalogIn(P2IN)),
                            ReflectSensor(AnalogIn(P3IN)),
                            ReflectSensor(AnalogIn(P4IN)) );
    DigitalOut  led1(LED1);
    Serial  pc(USBTX, USBRX);
#endif  
    timer.attach(&attime, ControlPeriod);
    
    for (;;) {
#ifdef Debug
        float pos = psens->Position();
        pc.printf("Position: %f, %f,%f,%f,%f, %d\n\r", pos, p1->Value(), p2->Value(), p3->Value(), p4->Value(), psens->Available());
        led1 = !psens->Available();
        wait(0.2);
#endif
    }
}