#include "lineTrace.h"

//-------------------------------------------------------//
LineTrace::LineTrace(LineSensors sensor, Motor left, Motor right)
    : s(sensor), L(left), R(right)
{}

//-------------------------------------------------------//
void LineTrace::Servo()
{
    const float Kp = 3.0;
    const float Kd = -2.0;

    const int N = 10;
   
    current = s.Position();
    integral = (integral + (N-1) * integral) / N;
    differential = current - integral;
    
    if (!s.Available()) {
        L.Move(0.0);
        R.Move(0.0);
        return;
    }        
    float cv = Kp * current + Kd * differential;
    if (cv < 0.0) {
        R.Move(1.0);
        L.Move(1.0 + cv);
    } else {
        L.Move(1.0);
        R.Move(1.0 - cv);
    }
 }
                
        