#include "lineSensor.h"

//-------------------------------------------------------//
ReflectSensor::ReflectSensor(AnalogIn ain) : AnalogIn(ain)
{}
//-------------------------------------------------------//
//-------------------------------------------------------//
float ReflectSensor::Value(void)
{
    return  1.0 - AnalogIn::read();
}

//-------------------------------------------------------//
LineSensors::LineSensors(AnalogIn ss1, AnalogIn ss2, AnalogIn ss3, AnalogIn ss4)
    : s1(ss1), s2(ss2), s3(ss3), s4(ss4)
{}

//-------------------------------------------------------//
LineSensors::LineSensors(ReflectSensor ss1, ReflectSensor ss2, ReflectSensor ss3, ReflectSensor ss4)
    : s1(ss1), s2(ss2), s3(ss3), s4(ss4)
{}
    
//-------------------------------------------------------//
float LineSensors::Position()   // Position of black line
{
    const float Coeff[] = {2.0, 1.0};
    // left    center   right
    // -1.0 ... 0.0 ... +1.0 
    float d1, d2, d3, d4;
    d1 = s1.Value();
    d2 = s2.Value();
    d3 = s3.Value();
    d4 = s4.Value();
    float mx = max(max(max(d1, d2), d3), d4);
    float pos = (Coeff[0] * (d4 - d1)  + Coeff[1] * (d3 - d2)) / (Coeff[0] + Coeff[1]);
    return (mx > 0.001) ? pos/mx : pos;
}

//-------------------------------------------------------//
int LineSensors::Available()
{
    const float AvailableMinimum = 0.2;
    float d1, d2, d3, d4;
    d1 = s1.Value();
    d2 = s2.Value();
    d3 = s3.Value();
    d4 = s4.Value();
    float mx = max(max(max(d1, d2), d3), d4);
    return mx > AvailableMinimum;
}