#ifndef STEERING_H
#define STEERING_H

#include "mbed.h"

void initIoExp(void);
int readIoExp(void);
void initSteering(void);

// 生データを2進数に変換するための配列
const int GTB[256] = {
  0,  1,  3,  2,  7,  6,  4,  5, 15, 14, 12, 13,  8,  9, 11, 10,
 31, 30, 28, 29, 24, 25, 27, 26, 16, 17, 19, 18, 23, 22, 20, 21,
 63, 62, 60, 61, 56, 57, 59, 58, 48, 49, 51, 50, 55, 54, 52, 53,
 32, 33, 35, 34, 39, 38, 36, 37, 47, 46, 44, 45, 40, 41, 43, 42,
127,126,124,125,120,121,123,122,112,113,115,114,119,118,116,117,
 96, 97, 99, 98,103,102,100,101,111,110,108,109,104,105,107,106,
 64, 65, 67, 66, 71, 70, 68, 69, 79, 78, 76, 77, 72, 73, 75, 74,
 95, 94, 92, 93, 88, 89, 91, 90, 80, 81, 83, 82, 87, 86, 84, 85,
255,254,252,253,248,249,251,250,240,241,243,242,247,246,244,245,
224,225,227,226,231,230,228,229,239,238,236,237,232,233,235,234,
192,193,195,194,199,198,196,197,207,206,204,205,200,201,203,202,
223,222,220,221,216,217,219,218,208,209,211,210,215,214,212,213,
128,129,131,130,135,134,132,133,143,142,140,141,136,137,139,138,
159,158,156,157,152,153,155,154,144,145,147,146,151,150,148,149,
191,190,188,189,184,185,187,186,176,177,179,178,183,182,180,181,
160,161,163,162,167,166,164,165,175,174,172,173,168,169,171,170
};

#define IOEXP_WRITEADD  0b01000000
#define IOEXP_READADD   0b01000001
//                             ||+-write:0(read:1)
//                             |+--A0:LOW
//                             +---A1:LOW
enum IOEXP_ENUM {
    IOEXP_IODIR = 0x00,
    IOEXP_IPOL,
    IOEXP_GPINTEN,
    IOEXP_DEFVAL,
    IOEXP_INTCON,
    IOEXP_IOCON,
    IOEXP_GPPU,
    IOEXP_INTF,
    IOEXP_INTCAP,
    IOEXP_GPIO,
    IOEXP_OLAT,
};

void initSteering(void);
void loadSteerAngle(void);
int getSteerAngle(void);
int getSteerDirection(void);

#endif