#ifndef GLOBAL_H
#define GLOBAL_H

//制御周期
const float CONTROL_CYCLE_S = 0.01f;
const int CONTROL_CYCLE_MS  = (int)(CONTROL_CYCLE_S * 1000.0f);
const int CONTROL_CYCLE_US  = (int)(CONTROL_CYCLE_S * 1000000.0f);

const float RPS_MEAS_CYCLE_S  = 0.01f;
const int RPS_MEAS_CYCLE_US  = (int)(RPS_MEAS_CYCLE_S * 1000000);

const float LSB_MOTORSPEED      = 0.01f;     //[(m/s) / bit]
const float LSB_RPS             = 0.0004f;    //[rps / bit]

//エラーカウンタ型
struct errCounter_t {
    int apsUnderVolt;       //aps電圧不足
    int apsExceedVolt;      //aps電圧超過
    int apsErrorTolerance;  //aps偏差超過
    int apsStick;           //aps固着
    int brakeUnderVolt;     //brake電圧不足
    int brakeExceedVolt;    //brake電圧超過
    int brakeFuzzyVolt;     //brake曖昧な電圧(ONでもOFFでもない)
    int brakeOverRide;      //accel-brake同時踏み
};

typedef enum {
    FR_WHEEL = 0, FL_WHEEL = 1, RR_MOTOR = 2, RL_MOTOR = 3, SELECT_T_NUM
}select_t;

const double M_PI            = 3.1415f;   //[-]

const double ratioLPF       = 0.67;          //各センサLPF:CutOff:20Hz
const double ratioLPF_ACC_BRK   = 0.061;     //各センサLPF:CutOff:1Hz
//const double ratioLPF_ACC_BRK   = 0.67;     //各センサLPF:CutOff:1Hz
const double ratioLPF_RPS    = 0.46;         //各センサLPF:CutOff:10Hz

#define myAbs(x)    (((x)>=0)?(x):(-(x)))
#define mySign(x)   (((x)>=0)?(1.0):(-1.0))
#define myMin(x,y)  (((x)<(y))?(x):(y))
#define myMax(x,y)  (((x)>(y))?(x):(y))

const double GEAR_RATIO      =13.0;     //[-]
const double TIRE_DIAMETER   =0.533;    //[m]
const double WHEEL_BASE      =1.760;    //[m]
const double TREAD           =1.3;      //[m]
//const double A               =0.005;    //[s^2/m^2]
const double A               =0.002;    //[s^2/m^2]
const double STEER_RATIO     =0.148;     //[-]
const double ALPHA           =5.0;      //[-]増幅率α

#endif