#include "mbed.h"
#include "Steering.h"
#include "Global.h"

extern SPI spi;
extern DigitalOut ioExpCs;
extern DigitalOut LED[];

Ticker ticker;

int gSteerAngle = 0;

void initIoExp(void)
{
    //SPIバスに複数のデバイスをぶら下げる場合，modeをそろえる必要がある
    spi.format(8, 0);
    spi.frequency(1000000);
    ioExpCs = 1;
    wait(0.1);    //Omajinai

    ioExpCs = 0;
    spi.write(IOEXP_WRITEADD);
    spi.write(IOEXP_IODIR);    //IO方向レジスタ
    spi.write(0xFF);    //All input
    ioExpCs = 1;
    wait_us(10);    //Omajinai

    ioExpCs = 0;
    spi.write(IOEXP_WRITEADD);
    spi.write(IOEXP_IPOL);    //入力極性
    spi.write(0xFF);    //All inverted
    ioExpCs = 1;
    wait_us(10);

    ioExpCs = 0;
    spi.write(IOEXP_WRITEADD);
    spi.write(IOEXP_GPPU);    //PULL-UP
    spi.write(0xFF);    //ALL PULL-UP
    ioExpCs = 1;
    wait_us(10);
}

int readIoExp(void)
{
    int gpio = 0;

    ioExpCs = 0;
    spi.write(IOEXP_READADD);
    spi.write(IOEXP_GPIO);
    gpio = spi.write(0x00);
    ioExpCs = 1;
    return gpio;
}

volatile bool steerIntFlag = false;

void loadSteerAngleISR(void)
{
    steerIntFlag = true;
}

void loadSteerAngle(void)
{
    if(steerIntFlag == true) {
        steerIntFlag = false;
        int readData = GTB[readIoExp()];

        if(readData == 127) {
            LED[2] = LED[3] = 1;
        } else if(readData < 127) {
            LED[2] = 1;
            LED[3] = 0;
        } else {
            LED[2] = 0;
            LED[3] = 1;
        }

        gSteerAngle = readData;
    }
}

int getSteerAngle(void)
{
    return gSteerAngle - 127;  //steer left->[+]
}

int getSteerDirection(void)
{
    return ((gSteerAngle > 127) ? 1 : 0); //steer left->1
}

void initSteering(void)
{
    initIoExp();
    ticker.attach(loadSteerAngleISR, 0.001);
}
