/**
* This programm demonstrates the changes and additions I made to :mbed Servo Library without using PWM pins
 * Copyright (c) 2010 Jasper Denkers
 * that allows independent cotrol of many servo's speed. The original Servo.h  cleverly uses a mix of MBED Ticker and Timeout functions 
 * to control the servos. Both of these functions are interrupt driven and so operate in the background. I added some more of these functions
 * to add the Variable Speed function.
 *
 * This program was tested on a Nucleo 152RE with a 40MHz clock and a ST DISCO F726NG running at 216MHz. 
 *
 * ANY pin on the MBED board, that can be configured as an output, may be used to drive a servo 
 *
 * Use of the library is both simple and straight forward;
 * create a new instance of the Servo object
 * enable that object setting the servo starting position, refesh rate, and desired servo speed
 *
 * write a program and use the statement --for example: Servo1.SetPosition(2300); and the servo will move, at the speed you specified.
 * the wait() statements in the example program are there to cause a pause to allow the servos to make a full transit, before returning,  as they are set to a rather slow speed.
 * The slow rate was chosen to demonstrate the library's ability to fully control a servo's speed. 
 * notes: 
 * The refresh rate for Analog servos is almost always 50 Hz or every 20mS. If you are using digital servos than a faster refresh rate can be used, up to 300 Hz
 * Servos draw a lot of power so do not attempt to use the MBED +5V to power more than, say , one 9g  small servo. A separate power supply is required for the servos.
 * Make sure to combine the board ground and servo power supply ground.
 *
 */


// Keep sweeping 2 servos from left to right at a slow rate. 

#include "mbed.h"
#include "Servo.h"


int main()
{

    Servo Servo1(D12);            // create new instance of servo with output pin number
    Servo Servo2(D10);
    Servo1.Enable(1500,50,10);    // Start position ; in us (1500 = center), servo refresh rate in Hz (analog servos = 50 Hz), servo movement speed range from 1-50, 1 slowest, about 20 seconds/180 degrees
    Servo2.Enable(1500,50,10);
    
    wait(5.0);
    while(1) {

        Servo1.SetPosition(700);
        Servo2.SetPosition(700);
        wait(2.5);
        
        Servo1.SetPosition(2300);
        Servo2.SetPosition(2300);
        wait(2.5);
    }

}



 