#include "mbed.h"
#include "DHT.h"
#include "ESP8266.h"
 
DHT sensor(D4, DHT11);
ESP8266 wifi(PTC17, PTC16, 115200);
Serial pc(USBTX,USBRX);
DigitalOut RED(LED1);
char snd[255],rcv[1000];
#define IP "184.106.153.149" // thingspeak.com IP Address
void wifi_send(void);

int main()
{
    pc.baud(115200);   
    pc.printf("SET mode to AP\r\n");
    wifi.SetMode(1);    // set ESP mode to 1
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s",rcv);    //Print the response onscreen
    pc.printf("Conneting to Wifi\r\n");
    wifi.Join("ssid", "password");     // Your wifi username & Password 
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s\n", rcv);    //Print the response onscreen
    wait(8);     //waits for response from ESP
    pc.printf("Getting IP\r\n");    //get IP addresss from the connected AP
    wifi.GetIP(rcv);    //receive an IP address from the AP
    pc.printf("%s\n", rcv);
    while (1) 
    {
        pc.printf("PLEASE STAY AWAY\r\n");
        pc.printf("Sending WiFi information\n");
        wifi_send();
        RED=1;
        wait(2.0f);
        RED=0;
        wait(1.5f);
    }    
}
void wifi_send(void){
    int error = 0;
    float h = 0.0f, c = 0.0f;
        
        wait(2.0f);
        error = sensor.readData();
        if (0 == error) 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            h   = sensor.ReadHumidity();
            //printf("Temperature in Celcius: %f\n", c);
            //printf("Humidity is %f\n", h);
        } 
        else 
        {
            printf("Error: %d\n", error);
        }
  //WIFI updates the Status to Thingspeak servers//
  strcpy(snd,"AT+CIPMUX=1\n");//Setting WiFi into MultiChannel mode
  wifi.SendCMD(snd);
  pc.printf(snd);
  wait(2.0);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s\n", rcv);
  wait(2);
  sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80\n",IP); //Initiate connection with THINGSPEAK server 
  pc.printf(snd);
  wait(3.0);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s\n", rcv);
  wait(2);
  strcpy(snd,"AT+CIPSEND=4,47\n");    //Send Number of open connections,Characters to send 
  wifi.SendCMD(snd);
  pc.printf(snd);
  wait(2.0);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s\n", rcv);
  wait(2);    
  sprintf(snd,"GET http://api.thingspeak.com/update?api_key=**********&field1=%1.3f\n", c); //Post values to thingspeak
  pc.printf("%s",snd);
  wifi.SendCMD(snd);
  wait(2);
  sprintf(snd,"GET http://api.thingspeak.com/update?api_key=***********&field2=%1.3f\n", h); //Post values to thingspeak
  pc.printf("%s",snd);
  wifi.SendCMD(snd);
  wait(2);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
}