#include "mbed.h"
#include "FXOS8700Q.h"
#include "FXOS8700CQ.h"
#include "FXAS21000.h"

// define all ports
PwmOut PWM1(D8); //moveForward
PwmOut PWM2(D9); //moveBack
PwmOut PWM3(D10); //left
PwmOut PWM4(D11); //right

DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);

Timer GlobalTime;
Timer ProgramTimer;

char c;
int flagBlue;
int sflag;
long loopStartTime;
long timer;

// define bluetooth and acc and gyro
Serial blue(D1,D0);     //(TX,DX)
Serial pc(USBTX, USBRX);    // Used to debug
FXOS8700Q_acc combo_acc(D14, D15, FXOS8700CQ_SLAVE_ADDR0);
FXOS8700Q_mag combo_mag(D14, D15, FXOS8700CQ_SLAVE_ADDR0);
FXAS21000 gyro(D14, D15);

//define functions
void start(void);
void stop(void);
void moveForward(void);
void moveBack(void);
void moveRight(void);
void moveLeft(void);

void blueInterrupt()
{
    c = blue.getc(); //receives the command
    flagBlue=1;
}

int main()
{
    pc.baud(115200);    
    
    float gyro_data[3];
    MotionSensorDataUnits adata;
    MotionSensorDataUnits mdata;
    //int16_t acc_raw[3];

    //Bluetooth init
    blue.baud(115200);
    blue.attach(&blueInterrupt);
    
    
    printf("\r\nStarting\r\n\r\n");
    
    red = 0; green= 1;
    GlobalTime.start();
    
    PWM1.period_ms(20);           
    PWM1.pulsewidth_us(100);
    PWM2.pulsewidth_us(100);
    PWM3.pulsewidth_us(100);
    PWM4.pulsewidth_us(100);

    combo_acc.enable();
    combo_mag.enable();
    blue.printf("FXOS8700 Combo mag = %X\r\n", combo_mag.whoAmI());
    blue.printf("FXOS8700 Combo acc = %X\r\n", combo_acc.whoAmI());
    blue.printf("FXAS21000 Gyro = %X\r\n", gyro.getWhoAmI());
    
    
    ProgramTimer.start();
    loopStartTime = ProgramTimer.read_us();
    timer = loopStartTime;
    
    wait(1);
    
    c= blue.getc();
    if (c == 'x') 
    {
        sflag = 1;
        blue.printf("stop\n\r"); 
        red =0; green =1;
        stop();
    }
    else if (c == 'z')
    {
        blue.printf("up\n\r");
        wait(2);
        red = 1; green= 0;
        start();
    }
    else if (c == 'w') 
    {
        blue.printf("forward\n\r");
        moveForward();
    }
    else if (c == 's')
    {
        blue.printf("back\n\r");
        moveBack();
    }
    else if (c == 'a')
    {
        blue.printf("left\n\r");
        moveLeft();
    }
    else if (c == 'd')
    {
        blue.printf("right\n\r");
        moveRight();
    }     
    else blue.printf("%wrong command: \n\r", c);
    
    while(1) 
    {
        combo_acc.getAxis(adata);
        blue.printf("FXOS8700 Acc:   X:%6.3f Y:%6.3f Z:%6.3f\r\n", adata.x, adata.y, adata.z);
        
        combo_mag.getAxis(mdata);
        blue.printf("FXOS8700 Mag:   X:%6.2f Y:%6.2f Z:%6.2f\r\n", mdata.x, mdata.y, mdata.z);

        gyro.ReadXYZ(gyro_data);
        blue.printf("FXAS21000 Gyro: X:%6.2f Y:%6.2f Z:%6.2f\r\n", gyro_data[0], gyro_data[1], gyro_data[2]);
        
        blue.printf("\r\n");
        wait(1);
        
        
    }
       
}
void start(void)
{
}

void stop(void)
{
}

void moveForward(void)
{
}

void moveBack(void)
{
}

void moveRight(void)
{
}

void moveLeft(void)
{
}