/*
 * File: main.cpp
 * Program: iac-audit
 * Developer: Connor Horne
 * Description: Sensor reading and sending to cloud program made for the IAC. Built for use with the FRDM-K64F and attahced systems.
*/


// mbed headers
#include "mbed.h"
#include "ESP8266.h"
#include "picojson.h"
#include <string>

bool setup(ESP8266 * esp, Serial * output);
bool receive(ESP8266 * esp, Serial * output);

picojson::value v;
char * json;
char resp[1024]; //buffer for the responce
double field;
bool pass = false;

// entry point
int main()
{   
    // system wide vars
    mbed::Serial output(USBTX, USBRX);  
    ESP8266 esp(PTC17, PTC16, 115200);
    
    output.printf("starting esp8266\r\n");
    
    esp.Reset();
    wait(5);
    //esp.baud(115200);
    wait(5);
    
    output.printf("starting setup\r\n");    
    
    pass = setup(&esp, &output);
    
    output.printf("sending value\r\n");
    
    pass = receive(&esp, &output);
    
} // end main

bool setup(ESP8266 * esp, Serial * comm)
{
    char buffer[1024];
    char ip[256];
    char status[1024];
    
    comm->printf("!setting mode\r\n");
    esp->SetMode(3); //'1'
    esp->RcvReply(buffer, 9000);
    comm->printf("response: %s\r\n", buffer);
    
    comm->printf("!setting connection\r\n");
    esp->SetSingle();
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    
    /*comm->printf("!getting list\r\n");    
    esp->GetList(buffer);    
    comm->printf("got list\r\n");
    comm->printf("%s\r\n", buffer);*/
  
    comm->printf("!joining AP\r\n");    
    esp->Join("SSID", "password"); //change to SSID and Password
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    
    comm->printf("!getting IP\r\n");    
    esp->GetIP(ip);
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    comm->printf("ip: %s\r\n", ip);
    
    comm->printf("!getting connection status\r\n");    
    esp->GetConnStatus(status);
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    comm->printf("stats: %s\r\n", status);
    
    return true;
}

bool receive(ESP8266 * esp, Serial * comm)
{
    char buffer[2048];
    char cmd[64];
        
    comm->printf("!setting up TCP connection\r\n");   
    strcpy(cmd,"AT+CIPSTART=\"TCP\",\"184.106.153.149\",80");
    esp->SendCMD(cmd);
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    
    char message[512];
    sprintf(resp,"GET http://api.thingspeak.com/channels/246738/feeds.json?metadata=true&results=0\r\n"); //GET https://api.thingspeak.com/channels/215748/feeds/last\r\n
    comm->printf("!sending packet length \r\n");   
    sprintf(cmd, "AT+CIPSEND=%d", strlen(resp)+2);
    esp->SendCMD(cmd);
    esp->RcvReply(buffer, 5000);
    comm->printf("response: %s\r\n", buffer);
    
    comm->printf("!sending data packet\r\n");
    esp->SendCMD(resp);
    esp->RcvReply(buffer, 10000);
    comm->printf("response: %s\r\n", buffer);
    if(strlen(buffer)!=0)
    {
    comm->printf("response: %s\r\n", buffer);
    strcpy(json, buffer);
    char * json=(char*) malloc(strlen(buffer)+1);
          comm->printf("parsing\r\n");
          string err = picojson::parse(v, json, json + strlen(json));
          if(err.empty())
          {
           field=v.get("field1").get<double>();
          // comm->printf("field1 value: %f", field);
           }
          else
          {
              comm->printf("error parsing\r\n");
          }     
        }
    comm->printf("field1 value: %f", field);
    comm->printf("!closing TCP connection\r\n");   
    strcpy(cmd, "AT+CIPCLOSE");
    esp->SendCMD(cmd);
    esp->RcvReply(buffer, 7000);
    comm->printf("response: %s\r\n", buffer);
    
    return true;
}