#include "mbed.h"
#include "ESP8266.h" 
ESP8266 wifi(PTC17, PTC16, 115200);
Serial pc(USBTX,USBRX);
DigitalOut RED(LED1);
char snd[255],rcv[1000];
char http_cmd[300];
float cur = 0.0f;//current value
float comp = 0.0f;//compressed air flow
float temp = 0.0f;//temperature
float hum = 0.0f;// humidity
float co = 0.0f;// CO2 
float pres = 0.0f;//pressure
#define IP "http://184.106.153.149/update" // thingspeak.com IP Address
void wifi_send(void);

int main()
{
    pc.baud(115200);
    wifi.Reset();
    pc.printf("SET mode to AP\r\n");
    wifi.SetMode(1);    // set ESP mode to 1
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s",rcv);    //Print the response onscreen
    pc.printf("Conneting to Wifi\r\n");
    wifi.Join("moto x play", "motoxplay");     // Your wifi username & Password 
    wifi.RcvReply(rcv, 1000);    //receive a response from ESP
    pc.printf("%s\n", rcv);    //Print the response onscreen
    wait(8);     //waits for response from ESP
    pc.printf("Getting IP\r\n");    //get IP addresss from the connected AP
    wifi.GetIP(rcv);    //receive an IP address from the AP
    pc.printf("%s\n", rcv);
    //WIFI updates the Status to Thingspeak servers//
    pc.printf("PLEASE STAY AWAY\r\n");
    pc.printf("Sending WiFi information\r\n");
    strcpy(snd,"AT+CIPMODE=0");//Setting WiFi into MultiChannel mode
    wifi.SendCMD(snd);
    pc.printf(snd);
    wifi.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
 
  //WIFI updates the Status to Thingspeak servers//
  strcpy(snd,"AT+CIPMUX=1");//Setting WiFi into MultiChannel mode
  wifi.SendCMD(snd);
  pc.printf(snd);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  
  
  sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80",IP); //Initiate connection with THINGSPEAK server 
  wifi.SendCMD(snd);
  //pc.printf(snd);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
    wait(2);
    strcpy(http_cmd,"GET http://api.thingspeak.com/update?api_key=54JPIP9GVWVX9BMV&field1=%f&field2=%f&field3=%f&field4=%f&field5=%f&field6=%f HTTP/1.0\r\n");
    sprintf(snd,"AT+CIPSEND=4,%d\r\n",strlen(http_cmd));    //Send Number of open connections,Characters to send 
    wifi.SendCMD(snd);
    pc.printf(snd);
    wait(2.0);
    wifi.RcvReply(rcv, 1000);
    pc.printf("%s\n", rcv);
    wait(2);
    while (1) 
    {
        wifi_send();
        RED=1;
        wait(10);
        RED=0;
        wait(10);
    }    
}
void wifi_send(void)
{            
  sprintf(http_cmd,"GET http://api.thingspeak.com/update?api_key=54JPIP9GVWVX9BMV&field1=%f&field2=%f&field3=%f&field4=%f&field5=%f&field6=%f HTTP/1.0\r\n", cur,comp,temp,hum,co,pres); //Post values to thingspeak
  pc.printf("%s",http_cmd);
  wifi.SendCMD(http_cmd);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
}