#include "mbed.h"
#include "MMA8451Q.h"
//#include "TextLCD.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

Serial pc(USBTX, USBRX); //tx, rx (tx,rx) -> (tx, rx)
//TextLCD display(PTC9, PTC8, PTA5, PTA4, PTA12, PTD4, TextLCD::LCD16x2); // rs, e, d4-d7
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
PwmOut RB(PTB0);	//direita - ré (verde)					|
PwmOut RF(PTB1);	//direita - frente (azul)				|
PwmOut LB(PTB2);	//esquerda - ré	(amarelo)				---> MUDAR PINAGEM
PwmOut LF(PTB3);	//esquerda - frente	(laranja)			|
DigitalOut led_direita(PTD3);      //
DigitalOut led_esquerda(PTD2);      // INSERT LEDS
DigitalOut led_frente(PTD0);      //
DigitalOut led_tras(PTD5);      //

float x1, x2;		//
float y, y2;		// acelerações
float z1, z2;		//

float v = 0;		//velocidade do motor
char c;				//serial buffer

/*void LCD(TextLCD lcd){
	const char equipe[10][16] = {"  ULISSES","   FURA-OLHO2.0", "Afonso", "Angelica", "Diego", "Jonatas",
	 "Natalia", "Pedro", "Wanderley", "Welton"};

        for(int i = 0; i < 10; i += 2){
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf(equipe[i]);
            lcd.locate(0,1);
            lcd.printf(equipe[i+1]);
            wait(1.5);
        }
}*/

bool upsideDown() {
    //Checa se o robô está de cabeça para baixo, indicando através de um led.
    
    z1 = acc.getAccZ();
    wait(5e-3);         //debounce
    z2 = acc.getAccZ();
    
    if(z1 < -0.3 && z2 < -0.3) {
        led_direita = 1;
        led_esquerda = 1;
        led_frente = 1;
        led_tras = 1;
        return true;
    }
    else if(z1 > 0.3 && z2 > 0.3) {
        led_direita = 1;
        led_esquerda = 1;
        led_frente = 1;
        led_tras = 1;
        return false;
    }
}


void xyTranslation() {
    //Checa se o robô está indo para frente ou para trás, indicando o sentido através de leds.
    
    x1 = acc.getAccX();
    wait(5e-3);         //debounce
    x2 = acc.getAccX();
    
    if(x1 < -0.07 && x2 < -0.07) {
        led_frente = 0;
        led_tras = 1;
    }
    else if(x1 > 0.07 && x2 > 0.07) {
        led_frente = 1;
        led_tras = 0;
    }
    else {
        led_frente = 0;
        led_tras = 0;
    }
}


void xyRotation() {
    //Checa se o robô está fazendo curva, indicando o sentido através de leds.
    
    y = acc.getAccY();
    wait(5e-3);         //debounce
    y2 = acc.getAccY();
    
    pc.printf("Y1: %.4f;Y2: %.4f;\t\t\t", y, y2);
    
    if(y < -0.07 && y2 < -0.07) {
        led_direita = 1;
        led_esquerda = 0;
    }
    else if(y > 0.07 && y2 > 0.07) {
        led_direita = 0;
        led_esquerda = 1;
    }
    else {
        led_direita = 0;
        led_esquerda = 0;
    }
}


void controleMovimentos()  {
	if(upsideDown());
	else{ 	 	
		xyTranslation();
		xyRotation();
	}
}


void main() {
//    LCD(display);
    
    while (1) {
        c = pc.getc();
        //display.cls();
        //display.locate(0,0);
        //display.printf("COMANDO: %c", c);
        
        //Checando movimento com o acelerômetro:
        controleMovimentos();
        
		//Controle de velocidade:
        if (c >= '0' && c <= '9' || c == 'q') {
            if (c == 'q')
                c = '9' + 1;
            v = (c - '0') / 10.0;
        }
		
		//Controle de direção:
        switch (c) {
			case 'F':
				RF = v;
				LF = v;
				RB = 0;
				LB = 0;
				break;
			case 'B':
				RF = 0;
				LF = 0;
				RB = v;
				LB = v;
				break;
			case 'R':
				RF = 0;
				LF = v;
				RB = v;
				LB = 0;
				break;
			case 'L':
				RF = v;
				LF = 0;
				RB = 0;
				LB = v;
				break;
			case 'G':
				RF = v;
				LF = v;
				RB = 0;
				LB = 0;
				break;
			case 'I':
				RF = v;
				LF = v;
				RB = 0;
				LB = 0;
				break;
			case 'H':
				RF = 0;
				LF = 0;
				RB = v;
				LB = v;
				break;
			case 'J':
				RF = 0;
				LF = 0;
				RB = v;
				LB = v;
				break;
			case 'S':
				RF = 0;
				LF = 0;
				RB = 0;
				LB = 0;
				break;
        }
    }
}
