#include "mbed.h"
#include "LSM6DS3.h"
#include "FXOS8700CQ.h"

Serial pc(USBTX, USBRX, 115200); // tx, rx
LSM6DS3 LSM6DS3(PTE25,PTE24);
FXOS8700CQ fxos(PTE25,PTE24);
Data fxos_acc;
Timer t;
AnalogIn pot0(A0), pot1(A1), pot2(A2), pot3(A3);

unsigned long int start_time = 0, end_time = 0;
uint16_t adc_value;

int main() {
//    LSM6DS3.begin();
//    fxos.init();
    t.start();
    
    while(1)
    {
        start_time = t.read_us();
        //read Accel & Gyro
        fxos_acc = fxos.get_values();
        LSM6DS3.readAccel();
        LSM6DS3.readGyro();
        end_time = t.read_us();
        pc.printf("\nPass time: %d\n", end_time - start_time);
        //serial send Accel (board)
        pc.printf("BoardAccelerX[%f]\n",fxos_acc.ax);
        pc.printf("BoardAccelerY[%f]\n",fxos_acc.ay);
        pc.printf("BoardAccelerZ[%f]\n",fxos_acc.az);
        //serial send Accel (lsm6ds33)
        pc.printf("AccelerX[%f]\n",LSM6DS3.ax);
        pc.printf("AccelerY[%f]\n",LSM6DS3.ay);
        pc.printf("AccelerZ[%f]\n",LSM6DS3.az);
        //serial send Gyro
        pc.printf("GyroX[%f]\n",LSM6DS3.gx);
        pc.printf("GyroY[%f]\n",LSM6DS3.gy);
        pc.printf("GyroZ[%f]\n",LSM6DS3.gz);
        wait(3.0);
    }
}