/* Project Name: Mbed Game Console
 Date: 05/26/2014
 Project Content: The Game Console has two games: Hangman and Bingo
 (AB guess number game). User uses joystick to selct the game to play and type letters and numbers through PC keyboard. LCD screen prints out the game status.
 */
#include "mbed.h"
#include "C12832_lcd.h"
#include "DebouncedIn.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
Serial pc(USBTX, USBRX);
DebouncedIn top(p15);
DebouncedIn bottom(p12);
DebouncedIn left(p13);
DebouncedIn right(p16);
DebouncedIn center(p14);
C12832_LCD lcd;
PwmOut spkr(p26);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

Ticker time0;
float i;

int game;
bool start;
int hangman_win;
int bingo_win;

void game_choice();
void display();
void winning_sound();
void losing_sound();
void rgb_flash(int rgb_type);
void hangman();
void bingo();

enum states {INIT_ST,STOP_ST,GAME0_ST,GAME1_ST,GAME_OVER_ST,DISPLAY_ST};
enum states state=INIT_ST;

// dictionary of words to play with
char *list[12] ={
    "banana", "programmer",
    "tongue", "favourite",
    "serendipity", "sportman",
    "harmony", "goalkeeper",
    "operation", "hamstring",
    "vibration", "wonderful"
};

int main()
{
    pc.printf("Game ON\r\n");
    time0.attach(&game_choice,0.01);
    while(1){
        switch(state){
            case INIT_ST:
                rgb_flash(0);
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("UP:Hangman\n");
                lcd.printf("DOWN:Bingo\r\n");
                lcd.printf("Center: List history score\r\n");
                if (center.rising())
                    state=DISPLAY_ST;
                if (game==1)
                    state=GAME0_ST;
                if (game==2)
                    state=GAME1_ST;
                break;
                
            case GAME0_ST:
                game=0;
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Hangman Game Start\r\n");
                lcd.printf("Enter the letter:\r\n");
                hangman();
                wait(5);
                state=GAME_OVER_ST;
                break;
            case GAME1_ST:
                game=0;
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Bingo Game Start\r\n");
                lcd.printf("Enter 4 digits number:\r\n");
                bingo();
                wait(5);
                state=GAME_OVER_ST;
                break;
            case GAME_OVER_ST:
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("UP: Hangman, DOWN: Bingo, Center: Main Menu\r\n");
                if(game==1)
                    state=GAME0_ST;
                if(game==2)
                    state=GAME1_ST;
                if (center.rising())
                    state=INIT_ST;
                break;
            case DISPLAY_ST:
                display();
                if (center.rising())
                    state=INIT_ST;
                else
                    state=DISPLAY_ST;
                break;
                
        }
        wait(0.1);
    }
}

void game_choice(){
    if(top.rising())
        game=1;//hangman
    if(bottom.rising())
        game=2;//bingo
    if (left.rising())
        game=3;
    if (right.rising())
        game=4;
}

void display(){
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Scoreboard:\r\n");
    lcd.printf("Hangman win: %d",hangman_win);
    lcd.printf("Bingo win: %d",bingo_win);
}
void winning_sound(){
    for(int i=0;i<5;i++){
        spkr.period(0.00181-0.0002*i);//1/554
        spkr=0.5;
        wait(0.5);
    }
    spkr=0;
}
void losing_sound(){
    for(int i=0;i<5;i++){
        spkr.period(0.00181+0.001*i);//1/554
        spkr=0.5;
        wait(0.5);
    }
    spkr=0;
}
void rgb_flash(int rgb_type){
    if(rgb_type==0){
        //printf("rgb flash init");
        r.period(0.001);
        r=0.5;
        g=0.5;
        b=1;
    }
    else if (rgb_type==1){
        r.period(0.001);
        r=1;
        g=0.1;
        b=1;
    }

}
void bingo() {
    pc.printf("bingo\r\n");
    int num[4],ans[4];
    int n;
    int i,j,a(0),b(0);
    int loop;
    srand(time(NULL));
    
    //randomize num
    for(i = 0; i <= 3; i++){
        num[i] = rand()%9+1;
        for(j = 0; j < i; j++){
            if(num[i] == num[j])
                i--;
        }
    }
    
    //answer
    /* printf("Answer : ");
     
     for(i = 0; i <= 3; i++){
     printf("%d",num[i]);
     }
     
     printf("\r\n");*/
    
    
    //guessing number
    for(loop=0;loop<8;loop++){
        
        printf("input number : \r\n");
        scanf("%d",&n);
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("input number :%d \r\n",n);
        //partition of the answer
        ans[0] = n / 1000;
        ans[1] = n / 100 % 10;
        ans[2] = n / 10 % 10;
        ans[3] = n % 10;
        
        // judging A or B
        for(i = 0; i <= 3; i++){
            for(j = 0; j <= 3; j++){
                if(num[i] == ans[i]){
                    a++;
                    break;
                }
                else if(num[i] == ans[j])
                    b++;
            }
        }
        
        printf("%d A %d B\r\n",a,b);
        lcd.printf("%d A %d B\r\n",a,b);
        
        //game over
        if(a == 4){
            printf("BINGO!!!\n");
            lcd.printf("BINGO!!!\n");
            bingo_win++;
            winning_sound();
            rgb_flash(1);
            break;
        }
        else{
            a = 0;
            b = 0;
        }
    }
    if(a!=4){
        printf("GAME OVER.\r\n");
        printf("Answer : ");
        for(i = 0; i <= 3; i++){
            printf("%d",num[i]);
        }
        printf("\r\n");
        lcd.cls();
        lcd.printf("GAME OVER\r\n");
        lcd.printf("Answer : ");
        for(i = 0; i <= 3; i++){
            lcd.printf("%d",num[i]);
        }
        losing_sound();
    }
}
void hangman() {
    pc.printf("hangman\r\n");
    int wordi, lives=8;
    char word[25];
    int x,correct,i = 0;
    int length;
    char symb;
    
    // srand((unsigned int)time(NULL));
    printf("\nLet's start. You have %d lives \r\n", lives);
    wordi = rand() % 12;
    length = strlen(list[wordi]);
    
    for(x=0;x<length;x++)
    {
        word[x] = '-';
    }
    word[length] = 0;
    
    printf("%s\r\n",word);
    
    while ((lives>0) && (i < length))
    {
        correct = 0;
        printf("Enter a letter: \r\n");
        do{
            scanf("%c", &symb);
            
            //symb = tolower(symb);
            
            if((symb > 32) && ((symb < 97) || (symb > 122)))
            {
                printf("Invalid character\nEnter a letter: \r\n");
            }
            
        }while((symb < 97) || (symb > 122));
        
        for(x=0;x<length;x++)
        {
            if(symb == word[x])
            {
                printf("This character already used.\r\n");
                break;
            }
        }
        
        if(x==length)
        {
            // Remark out the next line for the "real" game.
            //   printf("%c, %s\r\n",symb,list[wordi]);
            
            for(x=0;x<length;x++)
            {
                if(symb == list[wordi][x])
                {
                    word[x] = symb;
                    i++;
                    correct = 1;
                }
            }
            lcd.cls();
            lcd.locate(0,0);
            
            if(correct == 0)
            {
                lives--;
                if(lives > 0)
                {
                    printf("Wrong. %i lives left.\r\n",lives);
                }
                else
                {
                    printf("You lose. :(\r\n");
                    printf("Word:%s\r\n",list[wordi]);
                    lcd.cls();
                    lcd.locate(0,2);
                    lcd.printf("You lose. :(\r\n");
                    lcd.printf("Word:%s\r\n",list[wordi]);
                    losing_sound();
                }
                
            }
            else
            {
                if(i < length)
                {
                    printf("Correct.\r\n");
                }
                else
                {
                    printf("You win! :)\r\n");
                    lcd.printf("You win! :)\r\n");
                    winning_sound();
                    hangman_win++;
                    rgb_flash(1);
                }
                
            }
            if(lives>0)
            {
                lcd.printf("%i lives left.\r\n",lives);
                lcd.printf("You have %s\r\n",word);
            }
        }
    }
}
