#include "mbed.h"

// You can write out debug strings via the mbed interface and the built-in mini-USB socket.
Serial pc(USBTX, USBRX);

// All 4 built-in LEDs defined.
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Example initialisation function
void initialise()
{
    // Baud rate not required over USB.
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    wait(1.0f);
    //*==========================================*
    // Do initialisation here
    //*==========================================*
    
    //*==========================================*
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    wait(1.0f);
}

// The LED blinking code was split out into 2 functions with different parameter
// passing methods to incrementally add more sophistication and complexity into
// the basic mbed_blinky example. Those familiar with C/C++ won't need this sort
// of help, but if mbed is your first foray into C/C++, this will help...

// Take the parameter passed to us in variable 'val' and use the value in it
// to update the LEDs. We essentially use the value in 'val' as a bit field
// telling us which LEDs to light up, in a way that corresponds directly to the
// bit position.
void updateLEDs(int val)
{
    led1 = val & 0x01;
    led2 = (val & 0x02) >> 1;
    led3 = (val & 0x04) >> 2;
    led4 = (val & 0x08) >> 3;
}

// A simple bitwise shifting function to create an LED chaser effect.
// This function is different as it takes a pointer to the original variable.
// i.e., it is expecting the address to an int variable, not simply the value
// itself.
void advanceLEDs(int *val)
{
    *val = *val << 1;
    if(*val>0x08) *val = 1;
}

int main()
{
    initialise();
    
    int i = 1;
    while(1)
    {
        updateLEDs(i);
        advanceLEDs(&i);
        wait(0.5f);
    }
}