//***********************************************************
// Freescale Freedom KL25Z Demo
// Jason CJ Tay (jason.tay@vagler.com)
// 30 October 2013
//***********************************************************
// Key things demo'd:
// 1. USB application serial, USB CDC serial, not over the debug port.
// 2. Capacitive Touch
// 3. Accelerometer
// 4. RGB LED
//***********************************************************

#include "mbed.h"
#include "USBSerial.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

/// Freescale Freedom KL25Z board has an RGB LED on it.
DigitalOut ledRed(LED_RED);
DigitalOut ledGreen(LED_GREEN);
DigitalOut ledBlue(LED_BLUE);

/** Setup the serial over USB virtual COM port.
 * Note that the connection is made over the application USB port, NOT the CMSIS-DAP USB port.
 * If you would like to use the debug/programmer USB port instead, the the following code:
 *
 * @code
 * Serial pc(USBTX,USBRX); 
 * @endcode
 *
 * Notice that the default mbed USB CDC device will block on this declaration until you attach the KL25Z board
 * to your PC's USB port and the device enumerates. After that, program execution will begin.
 */
USBSerial pc;

int main()
{
    char c;
    int i=0;
    /// Capacitive touch sensor, defined as tsi.
    TSISensor tsi;
    /// 3-axis MEMS accelerometer.
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

    pc.printf("\nHello World!\n");

    while (true) {
        pc.printf("\nTell me what you want!\nPress 't' to read the capacitive touch slider...\nPress 'a' to read the accelerometer...\n");
        pc.printf("Press 'r' to turn the LED red...\nPress 'g' to turn the LED green...\nPress 'b' to turn the LED blue...\n>>>\n");
        c = pc.getc();
        switch(c) {
            case 't':
                pc.printf("The current touch sensor reading is %f\n", tsi.readPercentage());
                break;
            case 'a':
                pc.printf("X: %f\nY: %f\nZ: %f\n", acc.getAccX(), acc.getAccY(), acc.getAccZ());
                break;
            case 'r':
                for(int j=0; j<4; j++) {
                    wait(0.5);
                    pc.printf("%d\n",i);
                    i++;
                    ledRed = !ledRed;
                }
                break;
            case 'g':
                for(int j=0; j<4; j++) {
                    wait(0.5);
                    pc.printf("%d\n",i);
                    i++;
                    ledGreen = !ledGreen;
                }
                break;
            case 'b':
                for(int j=0; j<4; j++) {
                    wait(0.5);
                    pc.printf("%d\n",i);
                    i++;
                    ledBlue = !ledBlue;
                }
                break;
            default:
                pc.printf("Oops. Don't have anything for you. Please try again.\n\n");
        }
    }
}
