#include "mbed.h"
#include "LSM303D.h"
#include <string>
 
SPI spi(p5, p6, p7); // mosi, miso, sclk
//SPI spi(p11, p12, p13);

Serial pc(USBTX, USBRX); // tx, rx

LSM303D sensor1(spi,p15);
LSM303D sensor2(spi,p16);
LSM303D sensor3(spi,p17);
LSM303D sensor4(spi,p18);

//LSM303D sensor1(spi,p27);
//LSM303D sensor2(spi,p28);
//LSM303D sensor3(spi,p29);
//LSM303D sensor4(spi,p30);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

 
int main() {
    sensor1.initialize();
    sensor2.initialize();
    sensor3.initialize();
    sensor4.initialize();
    
    int check[] = {0,0,0,0};
    
    int a[] = {sensor1.magnitometer(0)+ sensor1.magnitometer(1)+ sensor1.magnitometer(2),
                   sensor2.magnitometer(0)+ sensor2.magnitometer(1)+ sensor2.magnitometer(2),
                   sensor3.magnitometer(0)+ sensor3.magnitometer(1)+ sensor3.magnitometer(2),
                   sensor4.magnitometer(0)+ sensor4.magnitometer(1)+ sensor4.magnitometer(2)};
                   
    int b[] = {sensor1.magnitometer(0)+ sensor1.magnitometer(1)+ sensor1.magnitometer(2),
                   sensor2.magnitometer(0)+ sensor2.magnitometer(1)+ sensor2.magnitometer(2),
                   sensor3.magnitometer(0)+ sensor3.magnitometer(1)+ sensor3.magnitometer(2),
                   sensor4.magnitometer(0)+ sensor4.magnitometer(1)+ sensor4.magnitometer(2)};
    
    while (true)
    {
        for (int i=0; i<4; i++)
        {
            a[i] = b[i];
        }
        
        b[0] = sensor1.magnitometer(0)+ sensor1.magnitometer(1)+ sensor1.magnitometer(2);
        b[1] = sensor2.magnitometer(0)+ sensor2.magnitometer(1)+ sensor2.magnitometer(2);
        b[2] = sensor3.magnitometer(0)+ sensor3.magnitometer(1)+ sensor3.magnitometer(2);
        b[3] = sensor4.magnitometer(0)+ sensor4.magnitometer(1)+ sensor4.magnitometer(2);
        
        for (int i=0; i<4; i++)
        {
            if (b[i] == a[i])
                check[i]++;
            else
                check[i]--;
                
            if (check[i] < -5)
                check[i] = -5;
            else if (check[i] >15)
                check[i] = 15;
                
            
        }
                   
                   
                   
        if (check[0]<10)
            myled1 = 1;
        else 
            myled1 = 0;
            
        if (check[1]<10)
            myled2 = 1;
        else 
            myled2 = 0;
            
        if (check[2]<10)
            myled3 = 1;
        else 
            myled3 = 0;
            
        if (check[3]<10)
            myled4 = 1;
        else 
            myled4 = 0;
            
        wait(.01);
            
        //printf("%d,%d,%d,%d\n",check[0],check[1],check[2],check[3]);
            
                
    }       

    
}