/*
 * Adafruit NeoPixel 8x8 matrix example
 *
 * This program displays a couple simple patterns on an 8x8 NeoPixel matrix.
 *
 * 3 buttons are used for DigitalIns, 2 control the brightness up and down,
 * and the third switches patterns
 */

#include "mbed.h"
#include "NeoStrip.h"
#include "gt.h"

#include "MPU6050.h"

#define N 30
#define NUM_AINS 10

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
MPU6050 mpu;

NeoStrip strip(p19,N);

int16_t ax, ay, az;
float gousei;
int16_t gx, gy, gz;
int16_t count = 0;

AnalogIn ain(p15);
AnalogIn photoin(p16);
float absArray[NUM_AINS];
float ave;
int current;


//color
float random4;
float random_color; 
int red;
int green;
int blue;

//serial
int receiveval;

//ぼんやり消えていく
Timer t;
int minus = 5;
int lightval = 0;

int main()
{
    pc.printf("MPU6050 test\n\n");
    pc.printf("MPU6050 initialize \n");

    mpu.initialize();
    pc.printf("MPU6050 testConnection \n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \n");
    } else {
        pc.printf("MPU6050 test failed \n");
    }
    
    //t.start();
   
    while(1) {
        wait(0.001);
       
       //mic get analog in
        float ain_abs;
        ain_abs = fabs(ain - 0.5);
        absArray[current] = ain_abs;
        current++;
        current = current%NUM_AINS;
       // pc.printf("%f\n",ain_abs);
       
        // calc average
        float sum = 0;
        for (int i=0; i<NUM_AINS; i++) sum += absArray[i];
        ave = sum/NUM_AINS;
       
       //getmotion    
        mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);
        //writing current accelerometer and gyro position 
       gousei = (ax*ax + ay*ay + az*az)/1000;
       gousei = sqrt(gousei);

        pc.printf("%f\n", gousei);
       // pc.printf("%f\n", photoin.read());
        
       
    if(photoin.read() < 0.5)
    {
       if(gousei > 1000)
       {
            lightval = 255;
            for(int i = 0; i < N; i++)
            {
            strip.setPixel(i,lightval,0,0);
            }
            //pc.printf("test");
            // t.reset();  
        }
        else
        {
            //pc.printf("%f\n", t.read());
            lightval = lightval - minus;
            if(lightval < 0)
            {
                lightval = 0;
            }
            for(int i = 0; i < N; i++)
            {
            strip.setPixel(i,lightval,0,0);
            } 
        }       
    }
    else
    {
        // output
        if(ave > 0.3) {
            for(int i=0; i<N; i++) strip.setPixel(i, 0, 200, 0);
           // strip.write();       
        }
         else
        {
            for(int i = 0; i < N; i++)
        {
            strip.setPixel(i,0,0,0);
        } 
  }
  //pc.scanf("%d",receiveval);
}    


        strip.write();
    }
}
/*
void random_()
{
 for(int i=0; i<3000; i++){
    
    //random4 = random(0, 60);
    random_color = random(0, 6);
    
    if(random_color == 0){
      red = 50;
      green = 0;
      blue = 0;
    }else if(random_color == 1){
      red = 0;
      green = 50;
      blue = 0;
    }else if(random_color == 2){
      red = 0;
      green = 0;
      blue = 50;
    }else if(random_color == 3){
      red = 50;
      green = 50;
      blue = 0;
    }else if(random_color == 4){
      red = 50;
      green = 0;
      blue = 50;
    }else if(random_color == 5){
      red = 0;
      green = 50;
      blue = 50;
    }else if(random_color == 6){
      red = 50;
      green = 50;
      blue = 50;
    }
    
    strip.setPixel(random4, red, green, blue);
   
   strip.write();
  }
 
    
}
*/
