#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(PA_7, PA_6, PA_5, PA_4, "sd");  //mosi, miso, sck, cs

Serial pc_uart(PA_2, PA_3);          // This is USART1 tx, rx
Serial sensor_uart(PA_9, PA_10);     // This is USART2 tx, rx

DigitalOut led_read(PC_13);          // This is reading LED indicator
DigitalOut led_write(PB_11);         // This is writing LED indicator
DigitalIn button(PB_12);             // This is STOP button

Timer t;
char buf[5];
char reading_str[32];
char writing_str[32];
uint8_t writeflag = 0;

void SENSOR_USART_INT()  // sensor uart interrupt
{
    if (sensor_uart.getc() == 'R') {
        led_read = 1;
        sprintf(reading_str, "%d; %s;", t.read_ms(), sensor_uart.gets(buf, 5));
        writeflag = 1;
    }
}

int main()
{
    pc_uart.baud(115200);   //set baudrate of pc port
    sensor_uart.baud(9600); //set baudrate of sensorport

    mkdir("/sd/ultrasonic", 0777);

    FILE *fp = fopen("/sd/ultrasonic/test.csv", "w");
    if(fp == NULL) {
        pc_uart.printf("Could not open file for write\n");
    }
    fprintf(fp, "timestamp;value;\n");
    //fclose(fp);

    pc_uart.printf("\n\r\n\r|||||START_MAIN|||||\n\r");
    t.start();
    sensor_uart.attach(&SENSOR_USART_INT);

    while(1) {
        if (button)
            fclose(fp);
        if (writeflag) {
            led_write = 1;
            memcpy(writing_str, reading_str, 32);
            fprintf(fp, "%s\n", writing_str);
            writeflag = 0;
            fprintf(pc_uart, "%s\r\n", writing_str);
        }
        else {
            led_write = 1;
            wait (0.07);
        }
        led_read = 0;
        led_write = 0;
    }
}