#include "mbed.h"
#include "ESP8266.h"
#include "string.h"
#include "MPU6050.h"
#include "ledControl.h"
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2

Timer tmr;

DigitalInOut data_pin(A0);

int humidity;
int temperature;
ESP8266 esp(PTC4,PTC3,115200);
int x,y,z;
char rcv[1000],acc[1000],temp[100],hum[100];
char rs[10000];
int i;
MPU6050 mpu6050;           // class: MPU6050, object: mpu6050 
Ticker toggler1;
Ticker filter;           

void toggle_led1();
void toggle_led2();
void compFilter();

float pitchAngle = 0;
float rollAngle = 0;

//########################################
// DHT11 Library
//########################################
int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_ms(18);
    data_pin.write(1);
    wait_us(40);
    data_pin.input();

    // ACKNOWLEDGE or TIMEOUT
    unsigned int loopCnt = 10000;
    
    while(!data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    loopCnt = 10000;
    
    while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT
    for(int i=0; i<40; i++){
        
        loopCnt = 10000;
        
        while(!data_pin.read())if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        tmr.start();

        loopCnt = 10000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humidity    = bits[0]; 
    temperature = bits[2]; 

    uint8_t sum = bits[0] + bits[2];  

    if(bits[4] != sum)return DHTLIB_ERROR_CHECKSUM;
    
    return DHTLIB_OK;
    
}

char buffer[17];

//########################################
// End of DHT11 Library
//########################################

int main(void){
     
     pc.baud(9600);                              // baud rate: 9600
    mpu6050.whoAmI();                           // Communication test: WHO_AM_I register reading 
    wait(1);
    mpu6050.calibrate(accelBias,gyroBias);      // Calibrate MPU6050 and load biases into bias registers
    pc.printf("Calibration is completed. \r\n");
    wait(0.5);
    mpu6050.init();                             // Initialize the sensor
    wait(1);
    pc.printf("MPU6050 is initialized for operation.. \r\n\r\n");
    wait_ms(500);
    
    
     pc.printf("Receiving Wifi List\r\n");
    esp.GetList(rcv);
    pc.printf("%s", rcv);
    wait(7);
    
    pc.printf("Connecting to AP\r\n");
    esp.Join("esp_123", "1234test"); // Replace MyAP and MyPasswd with your SSID and password
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(10);
    
    pc.printf("Getting IP\r\n");
    esp.GetIP(rcv);
    pc.printf("%s", rcv);
    wait(10);
    
    pc.printf("Setting Mode=1\r\n");
    esp.SetMode(1);
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(5);
    
    pc.printf("Setting AT+CIPMUX=1\r\n");
    esp.SetMultiple();
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(5);
    
    pc.printf("Starting client mode\r\n");
    esp.CloseServerMode();
    esp.RcvReply(rcv, 1000);
    pc.printf("%s", rcv);
    wait(5);
    
    pc.printf("Getting Connection Status\r\n");
    esp.GetConnStatus(rcv);
    pc.printf("%s", rcv);
    
    
 
    
    //lcd_initial();
    
   // lcd_puts("=Nucleo - DHT11=");
    
    //for(;;){
    while(1){ 
         strcpy(rs, "AT+CIPSTART=1,\"TCP\",\"192.168.4.1\",333\r\n");
        esp.SendCMD(rs);
        esp.RcvReply(rcv, 2000);
        pc.printf("%s", rcv);
        wait(0.1);
        
        myled = !myled;
        strcpy(rs, "AT+CIPSEND=1,57\r\n");
        esp.SendCMD(rs);
        esp.RcvReply(rcv, 1000);
        pc.printf("%s", rcv);
        wait(0.1);
          
   
        
        //pc.printf(" _______________\r\n");
        //pc.printf("| Pitch: %.3f  degree \r\n",pitchAngle);
        //pc.printf("| Roll:  %.3f  degree \r\n",rollAngle);
        //pc.printf("|_______________\r\n\r\n");
        //pc.printf("| Accelerometer(g) | ax=%.3f | ay=%.3f | az=%.3f                \r\n",ax,ay,az);
        //pc.printf("| Gyroscope(deg/s) | gx=%.3f | gy=%.3f | gz=%.3f                \r\n",gx,gy,gz);
        //wait(1);
     
   
   
        if(!dht_read()){
            
            sprintf(buffer, "T %2d H %2d%", temperature,humidity);
            //pc.printf("%s \n\r", buffer);
           // pc.printf(" \n\r ");
            //lcd_putcmd(0x80);
            //lcd_puts(buffer);
            //sprintf(buffer, "H %2d%", humidity);
            //lcd_putcmd(0xc0);
            //pc.printf("%s%% \n\r", buffer); 
            //pc.printf(" \n\r ");
            //lcd_puts(buffer);
            //wait(0.5);
            
        }
        
        else
        {
            //lcd_putcmd(0x80);
           // lcd_puts("Sensor Error !!!");
             //pc.printf("!!!!Sensor Error!!! \n\r");
            //lcd_putcmd(0xc0);
            //lcd_puts("                ");
            
        }
        filter.attach(&compFilter, 0.005);    // Call the complementaryFilter func. every 5 ms (200 Hz sampling period)
        //sprintf(acc,"a x= %f y= %f z=%f ", ax,ay,az);
        //sprintf(prs,"s w = %d",w);
        //strcat(acc,buffer);
        sprintf(acc,"a ax= %.3f ay= %.3f az=%.3f P %.3f R %.3f", ax,ay,az,pitchAngle,rollAngle);
        strcat(acc,buffer);
        strcpy(rs,acc);
        esp.SendCMD(rs);
        pc.printf("%s", rs);
        esp.RcvReply(rcv, 1000);
        pc.printf("%s", rcv);
        wait(0.1);
        
        
        strcpy(rs, "AT+CIPCLOSE=1");
        esp.SendCMD(rs);
        esp.RcvReply(rcv, 2000);
        pc.printf("%s", rcv);
        
        wait(0.1);

 //       wait(1.5);
    
    }
    

}

void toggle_led1() {ledToggle(1);}
void toggle_led2() {ledToggle(2);}

/* This function is created to avoid address error that caused from Ticker.attach func */ 
void compFilter() {mpu6050.complementaryFilter(&pitchAngle, &rollAngle);}
