// 8 Jul
// did flowchart of states

// handle sd card with cdms team

// Jun 6
// WHAT IS TC exec code in L1 ack ? 

//Jan 7 
//added RLY_TMTC function
//added included related files


uint8_t received = 0;
uint16_t mid1;
uint16_t mid2;
uint16_t Nbytes;
uint32_t Data[2];
uint16_t nbytes;
uint8_t flash_counter = 0;
uint16_t crc16;
uint16_t mid;
uint32_t block;

#define delete_TC(tc_ptr) {\
    if(tc_ptr == gHEAD_NODE_TCL){\
        gHEAD_NODE_TCL = tc_ptr->next_TC;\
    }\
    delete tc_ptr;\
}

// typeof tm_ptr: Base_tm
// typeof tc_ptr: Base_tc
// typeof temp_xxxx: uint8_t




#define detect_ack(tm_ptr, temp_ack, tc_psc) {\
    if( tm_ptr != NULL ){\
        int length = TM_SHORT_SIZE;\
        if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
            length = TM_SHORT_SIZE;\
        }\
        else{\
            length = TM_LONG_SIZE;\
        }\
        uint16_t crc = crc16_gen(tm_ptr->TM_string, length-2);\
        if( (((crc & 0xFF00) >> 8) == tm_ptr->TM_string[length-2]) && ( (crc & 0x00FF) == tm_ptr->TM_string[length-1] ) ){\
            uint8_t temp8;\
            temp8 = tm_ptr->TM_string[TM_ACK_CODE_INDEX];\
            temp8 = temp8 & 0xE0;\
            if( (temp8 == 0xC0) || (temp8 == 0xA0) )\
                temp_ack = 0x01;\
            else{\
                temp_ack = 0x00;\
                /*CHECK FOR NACK CODE: CRC FAIL NACK*/\
                temp8 = tm_ptr->TM_string[TM_ACK_CODE_INDEX];\
                temp8 = temp8 & 0x0F;\
                if( temp8 == CRC_FAIL_NACK_CODE ){\
                    tm_ptr->TM_string[2] = tc_psc;\
                }\
            }\
        }\
        else\
            temp_ack = 0x00;\
    }\
    else{\
        temp_ack = 0x00;\
    }\
}

#define isit_obosc(tc_ptr, temp_obosc) {\
    temp_obosc = 0x00;\
    if( GETapid(tc_ptr) == APID_COM ){\
        if( ((tc_ptr->TC_string[2]) >> 4) == SERVICE_OBOSC ){\
            temp_obosc = 0x01;\
        }\
    }\
}

#define isit_sdcard(tc_ptr, temp_sdcard) {\
    temp_sdcard = 0x00;\
    if( GETapid(tc_ptr) == APID_COM ){\
        if( ( (tc_ptr->TC_string[2]) >> 4) == SERVICE_OBSRS ){\
            temp_sdcard = 0x01;\
        }\
    }\
}



void after_cooling_pa(){
    gCOM_MNG_TMTC_THREAD->signal_set(COM_MNG_TMTC_SIGNAL_UART_INT);
}

/*
@brief:     check for missing tc, also check crc, i.e. 
            if true execution can be started else have to wait
            decide the next state
@param:     none
@return:    bool indicating whether there are missing tc
*/
// PENDING: LAST FRAME BIT
/*
for loop: check for missing tc
if: check for incorrect sized tc
if: check for last frame bit
*/
#define continueToExecute(returnHere) {\
    uint8_t tempReturn = 0x00;\
    /*search for missing psc*/\
    for(uint8_t p = 0x00 ; p < (gTOTAL_VALID_TC) ; ++p){\
        bool flag = false;\
        Base_tc *node_ptr = gHEAD_NODE_TCL;\
        while(node_ptr != NULL){\
            if( (GETpacket_seq_count(node_ptr) == p) && (GETcrc_pass(node_ptr) == 1) ){\
                flag = true;\
                break;\
            }\
            else{\
                node_ptr = node_ptr->next_TC;\
            }\
        }\
        if(flag == false){\
            tempReturn = 0x02;\
            break;\
        }\
    }\
    /*search for last packet bit*/\
    tempReturn = tempReturn + 0x01;\
    Base_tc *tcp = gHEAD_NODE_TCL;\
    while(tcp != NULL){\
        if(GETpacket_seq_count(tcp) == (gTOTAL_VALID_TC - 1)){\
            if( ( (tcp->TC_string[1]) & 0x20 ) == 0x20 ){\
                tempReturn = tempReturn - 0x01;\
            }\
            break;\
        }\
        tcp = tcp->next_TC;\
    }\
    returnHere = tempReturn;\
    /*UPDATE gMASTER STATE*/\
    if( (returnHere == 0x00) ){\
        if( (gMASTER_STATE == TCL_STATE_INCOMPLETE) || (gMASTER_STATE == TCL_STATE_COMPLETED) || (gMASTER_STATE == TCL_STATE_ABORTED) ){\
            gMASTER_STATE = TCL_STATE_EXECUTING;\
        }\
    }\
    else{\
        if( (gMASTER_STATE == TCL_STATE_INCOMPLETE) || (gMASTER_STATE == TCL_STATE_COMPLETED) ){\
            gMASTER_STATE = TCL_STATE_INCOMPLETE;\
        }\
    }\
}

/*
return 1 if code match
return 0 if code mismatch
*/
#define GScodeVerification(returnHere){\
    Base_tc *testTC = gHEAD_NODE_TCL;\
    uint16_t overflowCount = 0;\
    returnHere = 0xFF;\
    while( (overflowCount < TCL_OVERFLOW_CONSTANT) && (testTC != NULL) ){\
        if( (GETpacket_seq_count(testTC) == PSC_CALLSIGN) && (GETapid(testTC) == APID_CALLSIGN) ){\
            /*uint8_t temp8 = testTC->TC_string[1];*/\
            if( true ){\
                for( int i = 2 ; i <= 8 ; ++i ){\
                    if( testTC->TC_string[i] != gGSCODE[i-2] ){\
                        returnHere = 0;\
                        break;\
                    }\
                }\
            }\
            break;\
        }\
        testTC = testTC->next_TC;\
        ++overflowCount;\
    }\
    if(returnHere == 0xFF)\
    {\
        uint16_t temp = TC_STATE_SUCCESSFULLY_EXECUTED;\
        PUTexec_status(testTC,temp);\
    }\
}

/*
@brief:     DELETE THE CRC FAILED TC FROM THE LIST TO FREE-UP MEMORY AND UPDATE 
            THE TOTAL VALID TC AND GENERATE L1_ACK_TM
@param:     none
@return:    none
*/
/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */

/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */

// CDMS TEAM CODE START
inline Base_tm* FCTN_CDMS_RLY_TMTC(Base_tc *tc_ptr){
    uint8_t ACKCODE = 0xB0;
    //printf("\rTC execution in progress\r\n");
    Base_tm *tm_pointer = new Long_tm;
    Base_tm *tm_ptr = tm_pointer;
    received = 0;
    switch(GETapid(tc_ptr))
    {
        case 1: //apid=01 implies it corresponds to bae
        {
            gPC.printf("Telecommand is for BAE\r\n");
            //printf("Sending TC to BAE...\r\n"); //interrupt to be sent to the bae

                FCTN_I2C_WRITE((char*)tc_ptr->TC_string,TC_SHORT_SIZE);
            
            while(1)
            {
                wait(1); //TimeOut instead of wait
                if(BAE_I2C_GPIO == 1)
                {
                    
                    //printf("receiving...\r\n");
                    FCTN_I2C_READ((char*)tm_pointer->TM_string,135);
                    //printf("%s", tm_pointer->TM_string);
                    received+=1;
                    break; //only for testing purpose
                }
                else
                {
                    break;
                }
            }
            if(received < 1 )
            {
                //printf("Telemetry is not received from BAE\r\n");
                //tm_pointer = new Short_tm;
                tm_pointer->TM_string[0] = 0xB0;
                tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                tm_pointer->TM_string[2] = 0x00;
                tm_pointer->TM_string[3] = 0x00; //ackcode to be decided
                tm_pointer->TM_string[4] = 0x00;
                for(uint8_t i=0;i<6;i++)
                {
                    tm_pointer->TM_string[i+5] = 0;
                }
                crc16 = crc16_gen(tm_ptr->TM_string,11);
                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                tm_pointer->next_TM = NULL;                 return tm_ptr;
            }
            else
            {
                tm_pointer->next_TM = NULL; return tm_ptr;
                }
        }
        case 2:
        {
            //gPC.printf("Telecommand is for CDMS\r\n"); //apid = 10 corresponds to cdms
            switch(GETservice_type(tc_ptr))
            {
                case 0x60:
                {
                        //gPC.printf("service:MMS\r\n");
                        switch(GETservice_subtype(tc_ptr))
                        {
                            case 0x1:
                            {
                            //printf("sub_service:Read from RAM_Memory\r\n");
                            mid=(uint16_t)(tc_ptr->TC_string[3]<<4)+(uint16_t)(tc_ptr->TC_string[4]);                                                       
                                                             
                                    //Data[0] = FCTN_CDMS_RD_FLASH(0);
                                    //Data[1] = FCTN_CDMS_RD_FLASH(1);
                                    //tm_pointer = new Long_tm;
                                    tm_pointer->TM_string[0] = 0x30;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                                    tm_pointer->TM_string[2] = (uint8_t)(flash_counter);
                                    for(uint8_t i=0;i<4;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[0]>>(8*i))&0x00FF);
                                    }
                                    for(uint8_t i=4;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[1]>>(8*i))&0x00FF);
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,9);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                tm_pointer->next_TM = NULL;                 return tm_ptr;
                            }                            
                            case 0x2:
                            {
                            gPC.printf("sub_service:Read from Flash_Memory\r\n");
                            mid=(uint16_t)(tc_ptr->TC_string[3]<<4)+(uint16_t)(tc_ptr->TC_string[4]);                           
                                                                                             
                                    //Data[0] = FCTN_CDMS_RD_FLASH(0);
                                    //Data[1] = FCTN_CDMS_RD_FLASH(1);                                                                                             
                                    //tm_pointer = new Long_tm;
                                    tm_pointer->TM_string[0] = 0xB0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                                    tm_pointer->TM_string[2] = ACKCODE;
                                    for(uint8_t i=0;i<4;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[0]>>(8*i))&0x00FF);
                                    }
                                    for(uint8_t i=4;i<8;i++)
                                    {
                                        tm_pointer->TM_string[3+i] = (uint8_t)((Data[1]>>(8*i))&0x00FF);
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                tm_pointer->next_TM = NULL;                 return tm_ptr;
                            }                           
                            case 0x5:
                            {
                            //printf("WRITE ON FLASH_MEMORY\r\n");                          
                                    mid=(uint16_t)(tc_ptr->TC_string[3]<<4)+(uint16_t)(tc_ptr->TC_string[4]);                                   
                                    block = (((uint32_t)(tc_ptr->TC_string[5])<<24)|((uint32_t)(tc_ptr->TC_string[5])<<16)|((uint32_t)(tc_ptr->TC_string[5])<<8)|((uint32_t)(tc_ptr->TC_string[5])));
                                    //FCTN_CDMS_WR_FLASH(mid,block);
                                    //tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xB0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                            }                                                    
                            default:
                            {
                                //printf("INVALID TC\r\n"); //Send Invalid TC Telemetry
                                //tm_pointer = new Short_tm;
                                tm_pointer->TM_string[0] = 0xB0;
                                tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                                tm_pointer->TM_string[2] = 0x01;
                                tm_pointer->TM_string[3] = ACKCODE;  //ackcode to be decided
                                tm_pointer->TM_string[4] = 0x01;
                                for(uint8_t i=0;i<6;i++)
                                {
                                    tm_pointer->TM_string[i+5] = 0;
                                }
                                crc16 = crc16_gen(tm_ptr->TM_string,11);
                                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                tm_pointer->next_TM = NULL;                 return tm_ptr;                               
                            }
                            break;
                        }
                    }                                                                   
                    case 0x8:
                    {
                        //printf("service:FUNCTION MANAGEMENT SERVICE\r\n"); 
                        if(GETservice_subtype(tc_ptr)==0x1)
                            {                               
                              if(GETpid(tc_ptr)==0x01)
                                {
                                    //printf("TC_PL_INIT\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }                                
                                else if(GETpid(tc_ptr)==0x02)
                                {
                                    //printf("TC_PL_MAIN\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                               else if(GETpid(tc_ptr)==0x03)
                                {
                                    //printf("TC_COM_INIT\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x04)
                                {
                                    //printf("TC_CDMS_HK_MAIN\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;                                   
                                }
                                else if(GETpid(tc_ptr)==0x11)
                                {
                                    //printf("TC_SW_ON_SD\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x12)
                                {
                                    //printf("TC_SW_ON_RTC\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x13)
                                {
                                    //printf("TC_SW_ON_BAE\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x14)
                                {
                                    //printf("TC_SW_ON_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                 else if(GETpid(tc_ptr)==0x15)
                                {
                                    //printf("TC_SW_ON_PL_AG_HV\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                 else if(GETpid(tc_ptr)==0x16)
                                {
                                    //printf("TC_SW_ON_V_A_EN\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;                                   
                                }
                                else if(GETpid(tc_ptr)==0x21)
                                {
                                    //printf("TC_SW_OFF_SD\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x22)
                                {
                                    //printf("TC_SW_OFF_RTC\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x23)
                                {
                                    //printf("TC_SW_OFF_BAE\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x24)
                                {
                                    //printf("TC_SW_OFF_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                 else if(GETpid(tc_ptr)==0x25)
                                {
                                    //printf("TC_SW_OFF_PL_AG_HV\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                 else if(GETpid(tc_ptr)==0x26)
                                {
                                    //printf("TC_SW_OFF_V_A_EN\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                    
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x31)
                                {
                                    //printf("TC_RST_SD\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x32)
                                {
                                    //printf("TC_RST_RTC\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x33)
                                {
                                    //printf("TC_RST_BAE\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0x34)
                                {
                                    //printf("TC_RST_PL_DL\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0xC1)
                                {
                                    //printf("RESET_HK_COUNTER\r\n"); // call PWR_SWCH_ON function
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = ACKCODE;                                   
                                    for(uint8_t i=3;i<11;i++)
                                    {
                                        tm_pointer->TM_string[i] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                    break;
                                }
                                else if(GETpid(tc_ptr)==0xF1)
                                {
                                    //printf("RD_RTC\r\n"); //call RD_RTC
                                    //tm_pointer = new Short_tm;
                                    tm_pointer->TM_string[0] = 0xD0;
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                                    tm_pointer->TM_string[2] = 0x01;
                                    uint64_t time = FCTN_CDMS_RD_RTC();
                                    tm_pointer->TM_string[3] = (uint8_t)((time&0xFF00000000000000)>>56);
                                    tm_pointer->TM_string[4] = (uint8_t)((time&0x00FF000000000000)>>48);
                                    tm_pointer->TM_string[5] = (uint8_t)((time&0x0000FF0000000000)>>40);
                                    tm_pointer->TM_string[6] = (uint8_t)((time&0x000000FF00000000)>>32);
                                    tm_pointer->TM_string[7] = (uint8_t)((time&0x00000000FF000000)>>24);
                                    tm_pointer->TM_string[8] = (uint8_t)((time&0x0000000000FF0000)>>16);
                                    tm_pointer->TM_string[9] = (uint8_t)((time&0x000000000000FF00)>>8);
                                    tm_pointer->TM_string[10] = (uint8_t)(time&0x00000000000000FF);
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                }                               
                                else 
                                {
                                    //printf("INVALID TC\r\n");
                                    //tm_pointer = new Short_tm; 
                                    tm_pointer->TM_string[0] = 0xB0; 
                                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                                    tm_pointer->TM_string[2] = 0x01;
                                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                                    tm_pointer->TM_string[4] = 0x01;
                                    for(uint8_t i=0;i<6;i++)
                                    {
                                        tm_pointer->TM_string[i+5] = 0;
                                    }
                                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                                }
                            }                          
                                              
                                     
                }
                default:
                {
                    //printf("INVALID TC"); //send invalid TC TM
                    //tm_pointer = new Short_tm; 
                    tm_pointer->TM_string[0] = 0xB0; 
                    tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
                    tm_pointer->TM_string[2] = 0x01;
                    tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
                    tm_pointer->TM_string[4] = 0x01;
                    for(uint8_t i=0;i<6;i++)
                    {
                        tm_pointer->TM_string[i+5] = 0;
                    }
                    crc16 = crc16_gen(tm_ptr->TM_string,11);
                    tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                    tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
                    tm_pointer->next_TM = NULL;                 return tm_ptr;
                    break;
                }
            }
        }
        case 3:
        {
            #if DEBUG
            printf("Telecommand is for PL\r\n");
            #endif
            received = 0;

            if(GETservice_subtype(tc_ptr) == 0xD0 || GETservice_subtype(tc_ptr) == 0xD2 || GETservice_subtype(tc_ptr) == 0xD3)
            {
                PL_TM_SIZE = TM_LONG_SIZE;
            }
            else
            {
                PL_TM_SIZE = TM_LONG_SIZE;
            }   
                
            if(GETshort_or_long_tc(tc_ptr) == LONG_TC_CODE)
                FCTN_I2C_WRITE_PL((char*)tc_ptr->TC_string,TC_LONG_SIZE);
            else 
            {
                FCTN_I2C_WRITE_PL((char*)tc_ptr->TC_string,TC_SHORT_SIZE);
            }
            
            while(1)
            {
                wait(1);
                if(rcv_isr == 1)
                {
                    //gPC.printf("i2c_t = %d",t_pl.read_ms());  
                        for(int i = 0;i< PL_TM_SIZE;i++)
                        tm_pointer->TM_string[i] = PL_I2C_DATA[i];
                        received++;
                        rcv_isr = 0; 
                        break;
                }
                else
                {
                    gPC.printf("\n\rData received from PL \n");
                    break;
                    }
            }
            if(received < 1 )
            {
                //printf("Telemetry is not received from BAE\r\n");
                //tm_pointer = new Short_tm;
                tm_pointer->TM_string[0] = 0xB0;
                tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);
                tm_pointer->TM_string[2] = 0x00;
                tm_pointer->TM_string[3] = 0x00; //ackcode to be decided
                tm_pointer->TM_string[4] = 0x00;
                for(uint8_t i=0;i<6;i++)
                {
                    tm_pointer->TM_string[i+5] = 0;
                }
                crc16 = crc16_gen(tm_ptr->TM_string,11);
                tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
                tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
            }
            tm_pointer->next_TM = NULL;                 return tm_ptr;          
            break;
        }
        default: //invalid TC
        {
            //printf("INVALID TC\r\n");
            //tm_pointer = new Short_tm; 
            tm_pointer->TM_string[0] = 0xB0; 
            tm_pointer->TM_string[1] = GETpacket_seq_count(tc_ptr);                                    
            tm_pointer->TM_string[2] = 0x01;
            tm_pointer->TM_string[3] = ACKCODE; //ackcode to be decided
            tm_pointer->TM_string[4] = 0x01;
            for(uint8_t i=0;i<6;i++)
            {
                tm_pointer->TM_string[i+5] = 0;
            }
            crc16 = crc16_gen(tm_ptr->TM_string,11);
            tm_pointer->TM_string[11] = (uint8_t)((crc16&0xFF00)>>8);
            tm_pointer->TM_string[12] = (uint8_t)(crc16&0x00FF);
            tm_pointer->next_TM = NULL;                 return tm_ptr;
            break;
        }
     }
}
// CDMS TEAM CODE END
// EXECUTE OBOSC
#define execute_obosc_core(tc_ptr, tm_ptr, reset_flag) {\
    uint8_t service_subtype = (tc_ptr->TC_string[2]) & 0x0F;\
    uint8_t temp8 = 0x00;\
    Base_tc *modify_this = gHEAD_NODE_TCL;\
    int modify_overflow = 0x00;\
    switch( service_subtype ){\
        case OBOSC_SUB_DISABLE:\
            /*gPC.puts("target psc are ");*/\
            for(int i = 3 ; i < 9 ; ++i){\
                /*gPC.printf("%u ", tc_ptr->TC_string[i]);*/\
            }\
            /*gPC.puts("\r\n");*/\
            /*gPC.puts("disable type obosc\r\n");*/\
            while( modify_this != NULL ){\
                if( modify_overflow < TCL_OVERFLOW_CONSTANT ){\
                    uint8_t modify_psc = GETpacket_seq_count(modify_this);\
                    /*gPC.printf("mosify_psc = %u\r\n", modify_psc);*/\
                    for( int i = 3 ; i < 9 ; ++i ){\
                        uint8_t target_psc = tc_ptr->TC_string[i];\
                        if( (target_psc == modify_psc) && (target_psc != 0) ){\
                            uint16_t tempExec = TC_STATE_DISABLED;\
                            PUTexec_status( modify_this, tempExec );\
                            break;\
                        }\
                    }\
                    modify_this = modify_this->next_TC;\
                    ++modify_overflow;\
                }\
                else{\
                    /*PENDING: RESET CDMS*/\
                    break;\
                }\
            }\
            break;\
        case OBOSC_SUB_RETRY:\
            /*gPC.puts("retry type obosc\r\n");*/\
            while( modify_this != NULL ){\
                if( modify_overflow < TCL_OVERFLOW_CONSTANT ){\
                    uint8_t modify_psc = GETpacket_seq_count(modify_this);\
                    for( int i = 3 ; i < 9 ; ++i ){\
                        uint8_t target_psc = tc_ptr->TC_string[i];\
                        if( (target_psc == modify_psc) && (target_psc != 0) ){\
                            uint16_t tempExec = TC_STATE_MARKED_RETRY;\
                            PUTexec_status( modify_this, tempExec );\
                            /*gPC.puts("reqquired tc found: disable\r\n");*/\
                            break;\
                        }\
                    }\
                    modify_this = modify_this->next_TC;\
                    ++modify_overflow;\
                }\
                else{\
                    /*PENDING: RESET CDMS*/\
                    break;\
                }\
            }\
            break;\
    }\
    Base_tm *ackl234new = new Short_tm;\
    ackl234new->next_TM = NULL;\
    /*return telemetry pointer here*/\
    tm_ptr = ackl234new;\
    ackl234new->TM_string[0] = TMID_ACK_L234 << 4;\
    ackl234new->TM_string[1] = GETpacket_seq_count(tc_ptr);\
    ackl234new->TM_string[2] = 0xA0;\
    for(int i = 3; i < 11; ++i){\
        ackl234new->TM_string[i] = 0x00;\
    }\
    uint16_t crc = crc16_gen(ackl234new->TM_string, TM_SHORT_SIZE-2);\
    ackl234new->TM_string[11] = (crc & 0xFF00) >> 8;\
    ackl234new->TM_string[12] = crc & 0x00FF;\
    /*ack l234 old*/\
    if( service_subtype == OBOSC_SUB_REP_LE ){\
        if( gLAST_TM_SHORT_OR_LONG == SHORT_TM_CODE ){\
            Base_tm *ackl234old = new Short_tm;\
            ackl234old->next_TM = NULL;\
            /*APPEND TO ACK L234 NEW HERE*/\
            ackl234new->next_TM = ackl234old;\
            for( int i = 0 ; i < TM_SHORT_SIZE ; ++i ){\
                ackl234old->TM_string[i] = gLAST_TM[i];\
            }\
        }\
        else{\
            Base_tm *tempLongTM = new Long_tm;\
            tempLongTM->next_TM = NULL;\
            /*APPEND TO ACK L234 NEW HERE*/\
            ackl234new->next_TM = tempLongTM;\
            for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){\
                tempLongTM->TM_string[i] = gLAST_TM[i];\
            }\
        }\
    }\
    else if( service_subtype == OBOSC_SUB_REP_TCLD ){\
        get_tc_list(ackl234new->next_TM, GETpacket_seq_count(tc_ptr));\
    }\
    else if( service_subtype == OBOSC_SUB_RESET ){\
        /*reset_all;*/\
        reset_flag = 1;\
        /*PENDING: VERIFY reset_all, RESET CDMS*/\
    }\
    else if( (service_subtype != OBOSC_SUB_DISABLE) && (service_subtype != OBOSC_SUB_RETRY) ){\
        /*CHANGE THE ACK CODE TO INVALID TC*/\
        ackl234new->TM_string[2] = 0xA2;\
    }\
    /*gPC.puts("completed obosc\r\n");*/\
}

/*tm_ptr is the next_TM of a linked list, and should have the value NULL, i.e. tm_ptr should be the next_TM pointer of thte last node */


#define EXECUTE_OBOSC_ONLY {\
    int reset_flag = 0;\
    for(uint8_t execute_psc = PSC_START_VALUE ; execute_psc < gTOTAL_VALID_TC ; ++execute_psc){\
        Base_tc* current_TC = gHEAD_NODE_TCL;\
        int overCount = 0;\
        while( current_TC != NULL ){\
            if( overCount < TCL_OVERFLOW_CONSTANT ){\
                if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                    /*CHECK FOR OBOSC*/\
                    uint8_t temp82 = 0x00;\
                    isit_obosc(current_TC, temp82);\
                    if(temp82 == 0x01){\
                        uint16_t current_exec_status = GETexec_status(current_TC);\
                        if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) )\
                            break;\
                        else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                            /*gPC.printf("It is obosc: %u\r\n", execute_psc);*/\
                            /*EXECUTION OF OBOSC TC*/\
                            /*WARNING: LARGE MEMORY UTILIZATION FOR TC-LIST-REPORT */\
                            Base_tm *obosc_tm_head = NULL;\
                            get_call_sign(obosc_tm_head);\
                            Base_tm *obosc_tm_core = NULL;\
                            execute_obosc_core(current_TC, obosc_tm_core, reset_flag);\
                            uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                            PUTexec_status(current_TC, temp16);\
                            Base_tm *obosc_tm_current = obosc_tm_head;\
                            get_ack_l1(obosc_tm_current->next_TM);\
                            int overflowCountOBONLY = 0;\
                            while( obosc_tm_current->next_TM != NULL ){\
                                if( overflowCountOBONLY < TM_OVERFLOW_CONSTANT ){\
                                    obosc_tm_current = obosc_tm_current->next_TM;\
                                    ++overflowCountOBONLY;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS*/\
                                    break;\
                                }\
                            }\
                            obosc_tm_current->next_TM = obosc_tm_core;\
                            obosc_tm_current = obosc_tm_head;\
                            while( obosc_tm_current != NULL ){\
                                int length = TM_SHORT_SIZE;\
                                if( GETshort_or_long_tm(obosc_tm_current) == SHORT_TM_CODE ){\
                                    length = TM_SHORT_SIZE;\
                                }\
                                else{\
                                    length = TM_LONG_SIZE;\
                                }\
                                for(int i = 0 ; i < length ; ++i){\
                                    /*gPC.putc(obosc_tm_current->TM_string[i]);*/\
                                }\
                                obosc_tm_current = obosc_tm_current->next_TM;\
                            }\
                            /*Sending OBOSC TM to GS*/\
                            /*snd_tm.head_pointer(obosc_tm_head);*/\
                            /*transmit_adf;*/\
                            /*DELETE THE TM AFTER USE*/\
                            obosc_tm_current = obosc_tm_head;\
                            int overCount = 0;\
                            while( obosc_tm_current != NULL ){\
                                if( (overCount < TM_OVERFLOW_CONSTANT) ){\
                                    Base_tm *temp = obosc_tm_current->next_TM;\
                                    delete obosc_tm_current;\
                                    obosc_tm_current = temp;\
                                    ++overCount;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS: MEMORY LEAK FOUND*/\
                                    break;\
                                }\
                            }\
                            if ( reset_flag ==1 ){\
                                reset_all;\
                            }\
                        }\
                    }\
                }\
                current_TC = current_TC->next_TC;\
                ++overCount;\
            }\
            else{\
                /*PENDING: REST CDMS: MEMORY LEAK FOUND*/\
                break;\
            }\
        }\
    }\
}

#define EXECUTE_TC {\
    gMASTER_STATE = TCL_STATE_EXECUTING;\
    /*gPC.printf("%u\r\n", gTOTAL_VALID_TC);*/\
    for(uint8_t execute_psc = PSC_START_VALUE ; execute_psc < gTOTAL_VALID_TC ; ++execute_psc ){\
        /*gPC.printf("executing normal %u\r\n", execute_psc);*/\
        /*gLEDG = !gLEDG;*/\
        /*gLEDR = !gLEDR;*/\
        Base_tc* current_TC = gHEAD_NODE_TCL;\
        int overflowCount = 0;\
        while(current_TC != NULL){\
            if( overflowCount < TCL_OVERFLOW_CONSTANT ){\
                if( (GETcrc_pass(current_TC) == 1) && (GETpacket_seq_count(current_TC) == execute_psc) ){\
                    uint8_t current_exec_status = GETexec_status(current_TC);\
                    if( (current_exec_status == TC_STATE_SUCCESSFULLY_EXECUTED) || (current_exec_status == TC_STATE_DISABLED) ){\
                        /*gPC.printf("disabled or completed at %u\n", execute_psc);*/\
                        break;\
                    }\
                    else if( (current_exec_status == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                        /*gPC.printf("abort on nack at %u psc\r\n", execute_psc);*/\
                        gMASTER_STATE = TCL_STATE_ABORTED;\
                        Base_tm *tm_ptr_head = NULL;\
                        get_call_sign(tm_ptr_head);\
                        Base_tm *tm_ptr = tm_ptr_head;\
                        get_ack_l1(tm_ptr->next_TM);\
                        tm_ptr = tm_ptr_head;\
                        while( tm_ptr != NULL ){\
                            int length = TM_SHORT_SIZE;\
                            if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
                                length = TM_SHORT_SIZE;\
                            }\
                            else{\
                                length = TM_LONG_SIZE;\
                            }\
                            /*gPC.puts("Printing Call Sign, ACK_L1, TM list");*/\
                            for(int i = 0 ; i < length ; ++i){\
                                /*gPC.putc(tm_ptr->TM_string[i]);*/\
                            }\
                            tm_ptr = tm_ptr->next_TM;\
                        }\ 
                        /*Send only call sign, ACK_L1 to GS*/\
                        /*snd_tm.head_pointer(tm_ptr_head);*/\
                        /*transmit_adf;*/\
                        /*DELETE THE TM AFTER USE*/\
                        tm_ptr = tm_ptr_head;\
                        int overflowCountExecute = 0;\
                        while(tm_ptr != NULL){\
                            if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                Base_tm *temp = tm_ptr->next_TM;\
                                delete tm_ptr;\
                                tm_ptr = temp;\
                                ++overflowCountExecute;\
                            }\
                            else{\
                                /*PENDING: RESET CDMS*/\
                                break;\
                            }\
                        }\
                        break;\
                    }\
                    else if( (current_exec_status == TC_STATE_UNEXECUTED) || (current_exec_status == TC_STATE_MARKED_RETRY) ){\
                        /*EXECUTION OF TC START*/\
                        uint8_t temp81 = 0x00;\
                        isit_sdcard(current_TC, temp81);\
                        if( temp81 == 0x00 ){\
                            /*gPC.printf("non sd card at %u\r\n", execute_psc);*/\
                            /*EXECUTION OF NON SD-CARD (BOTH OBOSC and CDMS functions)*/\
                            Base_tm *tm_ptr_head = NULL;\
                            get_call_sign(tm_ptr_head);\
                            Base_tm *put_tm_here = NULL;\
                            uint8_t temp82 = 0x00;\
                            uint8_t tempPAhot = 0x00;\
                            isit_obosc(current_TC, temp82);\
                            if(temp82 == 0x01){\
                                /*gPC.printf("obosc tc inside normal tc at %u\r\n", execute_psc);*/\
                                /*EXECUTION OF OBOSC TC*/\
                                /*SKIP EXECUTION OF OBOSC HERE*/\
                                break;\
                            }\
                            else{\
                                /*gPC.printf("cdms relay tmtc at %u\r\n", execute_psc);*/\
                                /*call CDMS_RLY_TMTC*/\
                                /*CDMS_RLY_TMTC(current_TC, put_tm_here);*/\
                                put_tm_here =  FCTN_CDMS_RLY_TMTC(current_TC);\
                            }\
                            /*DETECT ACK OR NACK*/\
                            uint8_t temp83 = 0x00;\
                            uint8_t temp84 = GETpacket_seq_count(current_TC);\
                            detect_ack(put_tm_here, temp83, temp84);\
                            if( temp83 == 0x01){\
                                uint16_t temp16 = TC_STATE_SUCCESSFULLY_EXECUTED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            else{\
                                /*gPC.puts("TC_STATE_EXECUTION_FAILED");*/\
                                uint16_t temp16 = TC_STATE_EXECUTION_FAILED;\
                                PUTexec_status(current_TC, temp16);\
                            }\
                            /*ABORT ON NACK AND TC LIST COMPLETED: UPDATE IN gMASTERSTATE*/\
                            if( (GETexec_status(current_TC) == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                                gMASTER_STATE = TCL_STATE_ABORTED;\
                            }\
                            else if( execute_psc == (gTOTAL_VALID_TC-1) ){\
                                /*LAST TC IS EXECUTED*/\
                                gMASTER_STATE = TCL_STATE_COMPLETED;\
                            }\
                            else{\
                                uint8_t check1 = 1;\
                                for( uint8_t test_psc = execute_psc+1 ; test_psc < gTOTAL_VALID_TC ; ++test_psc ){\
                                    Base_tc* test_TC = gHEAD_NODE_TCL;\
                                    while(test_TC != NULL){\
                                        if( GETpacket_seq_count(test_TC) == test_psc ){\
                                            uint8_t checkval;\
                                            isit_obosc(test_TC, checkval);\
                                            if( checkval == 0 ){\
                                                check1 = 0;\
                                            }\
                                        }\
                                        test_TC = test_TC->next_TC;\
                                    }\
                                }\
                                if( check1 == 0x01 ){\
                                    gMASTER_STATE = TCL_STATE_COMPLETED;\
                                }\
                            }\
                            /*update last executed L1_ack*/\
                            if( put_tm_here != NULL ){\
                                if( GETshort_or_long_tm(put_tm_here) == SHORT_TM_CODE ){\
                                    for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){\
                                        gLAST_TM[i] = put_tm_here->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = SHORT_TM_CODE;\
                                    }\
                                }\
                                else{\
                                    for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){\
                                        gLAST_TM[i] = put_tm_here->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = LONG_TM_CODE;\
                                    }\
                                }\
                            }\
                            /*PENDING: APPEND ACK L1*/\
                            Base_tm *tm_ptr = tm_ptr_head;\
                            get_ack_l1(tm_ptr->next_TM);\
                            int overflowCountExecute = 0;\
                            while( tm_ptr->next_TM != NULL ){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    tm_ptr = tm_ptr->next_TM;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS*/\
                                    break;\
                                }\
                            }\
                            tm_ptr->next_TM = put_tm_here;\
                            /*CHECK FOR HOT PA*/\
                            isPAhot(tempPAhot);\
                            if( tempPAhot == 0x00 ){\
                                gFLAGS = gFLAGS | COM_PA_HOT_FLAG;\
                            }\
                            tm_ptr = tm_ptr_head;\
                            while( tm_ptr != NULL ){\
                                int length = TM_SHORT_SIZE;\
                                if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
                                    length = TM_SHORT_SIZE;\
                                }\
                                else{\
                                    length = TM_LONG_SIZE;\
                                }\
                                /*gPC.puts("Printing Call Sign, ACK_L1, TM list");*/\
                                for(int i = 0 ; i < length ; ++i){\
                                    /*gPC.putc(tm_ptr->TM_string[i]);*/\
                                }\
                                tm_ptr = tm_ptr->next_TM;\
                            }\
                            /*SEND call sign, ACK_L1, NON OBSRS TM TO GS*/\
                            snd_tm.head_pointer(tm_ptr_head);\
                            gPC.puts("enter_adf\r\n");\
                            transmit_adf;\
                            gPC.puts("exit_adf\r\n");\ 
                            /*DELETE THE TM AFTER USE*/\
                            tm_ptr = tm_ptr_head;\
                            overflowCountExecute = 0;\
                            while(tm_ptr != NULL){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    Base_tm *temp = tm_ptr->next_TM;\
                                    delete tm_ptr;\
                                    tm_ptr = temp;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS*/\
                                    break;\
                                }\ 
                            }\
                        }\
                        else{\
                            /*gPC.printf("sd card at %u\r\n", execute_psc);*/\
                            /*EXECUTION OF SD-CARD DATA SENDING (OBSRS)*/\
                            Base_tm *tm_ptr_head = NULL;\
                            get_call_sign(tm_ptr_head);\
                            Base_tm *put_tm_here = NULL;\
                            /*execute_obsrs(current_TC, put_tm_here)*/\
                            /*read_TC(current_TC);*/\
                            execute_OBSRS_TC(current_TC);\
                            gPC.puts("enter_adf\r\n");\
                            transmit_adf;\
                            gPC.puts("exit_adf\r\n");\
                            uint8_t tempExec = TC_STATE_SUCCESSFULLY_EXECUTED;\
                            PUTexec_status(current_TC, tempExec);\
                            /*PENDING: ABORT ON NACK CHECK, gMASTER_STATE VERIFICATION WITH SD CARD, session timeout, last executed ack l234*/\
                            if( (GETexec_status(current_TC) == TC_STATE_EXECUTION_FAILED) && (GETabort_on_nack(current_TC) == 1) ){\
                                gMASTER_STATE = TCL_STATE_ABORTED;\
                            }\
                            else if( execute_psc == (gTOTAL_VALID_TC-1) ){\
                                gMASTER_STATE = TCL_STATE_COMPLETED;\
                            }\
                            else{\
                                uint8_t check1 = 1;\
                                for( uint8_t test_psc = execute_psc+1 ; test_psc < gTOTAL_VALID_TC ; ++test_psc ){\
                                    Base_tc* test_TC = gHEAD_NODE_TCL;\
                                    while(test_TC != NULL){\
                                        if( GETpacket_seq_count(test_TC) == test_psc ){\
                                            uint8_t checkval;\
                                            isit_obosc(test_TC, checkval);\
                                            if( checkval == 0 ){\
                                                check1 = 0;\
                                            }\
                                        }\
                                        test_TC = test_TC->next_TC;\
                                    }\
                                }\
                                if( check1 == 0x01 ){\
                                    gMASTER_STATE = TCL_STATE_COMPLETED;\
                                }\
                            }\
                            /*update last executed L1_ack*/\
                            if( put_tm_here != NULL ){\
                                if( GETshort_or_long_tm(put_tm_here) == SHORT_TM_CODE ){\
                                    for(int i = 0 ; i < TM_SHORT_SIZE ; ++i){\
                                        gLAST_TM[i] = put_tm_here->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = SHORT_TM_CODE;\
                                    }\
                                }\
                                else{\
                                    for( int i = 0 ; i < TM_LONG_SIZE ; ++i ){\
                                        gLAST_TM[i] = put_tm_here->TM_string[i];\
                                        gLAST_TM_SHORT_OR_LONG = LONG_TM_CODE;\
                                    }\
                                }\
                            }\
                            /*PENDING: APPEND ACK L1*/\
                            Base_tm *tm_ptr = tm_ptr_head;\
                            get_ack_l1(tm_ptr->next_TM);\
                            int overflowCountExecute = 0;\
                            while( tm_ptr->next_TM != NULL ){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    tm_ptr = tm_ptr->next_TM;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS*/\
                                    break;\
                                }\
                            }\
                            tm_ptr->next_TM = put_tm_here;\
                            /*CHECK FOR HOT PA*/\
                            uint8_t tempPAhot = 0x00;\
                            isPAhot(tempPAhot);\
                            if( tempPAhot == 0x00 ){\
                                gFLAGS = gFLAGS | COM_PA_HOT_FLAG;\
                            }\
                            tm_ptr = tm_ptr_head;\
                            while( tm_ptr != NULL ){\
                                int length = TM_SHORT_SIZE;\
                                if( GETshort_or_long_tm(tm_ptr) == SHORT_TM_CODE ){\
                                    length = TM_SHORT_SIZE;\
                                }\
                                else{\
                                    length = TM_LONG_SIZE;\
                                }\
                                /*gPC.puts("Printing Call Sign, ACK_L1, TM list");*/\
                                for(int i = 0 ; i < length ; ++i){\
                                    /*gPC.putc(tm_ptr->TM_string[i]);*/\
                                }\
                                tm_ptr = tm_ptr->next_TM;\
                            }\
                            /*SEND call sign, ACK_L1, OBSRS TO GS*/\
                            /*snd_tm.head_pointer(tm_ptr_head);*/\
                            /*adf_SDcard();*/\
                            /*DELETE THE TM AFTER USE*/\
                            tm_ptr = tm_ptr_head;\
                            overflowCountExecute = 0;\
                            while(tm_ptr != NULL){\
                                if( overflowCountExecute < TM_OVERFLOW_CONSTANT ){\
                                    Base_tm *temp = tm_ptr->next_TM;\
                                    delete tm_ptr;\
                                    tm_ptr = temp;\
                                    ++overflowCountExecute;\
                                }\
                                else{\
                                    /*PENDING: RESET CDMS*/\
                                    break;\
                                }\
                            }\
                        }\
                    }\
                    break;\
                }\
                current_TC = current_TC->next_TC;\
                ++overflowCount;\
            }\
            else{\
                /*PENDING: RESET CDMS*/\
                break;\
            }\
        }\
        if( gFLAGS & COM_SESSION_TIMEOUT_FLAG ){\
            break;\
        }\
        else if( gMASTER_STATE == TCL_STATE_ABORTED ){\
            /*gPC.puts("ABORTING DUE TO ABORT ON NACK\r\n");*/\
            /*EXITED DUE TO ABORT ON NACK:*/\
            /*PENDING : POWER OFF COM TX*/\
            RX1M.attach(&rx_read, Serial::RxIrq);\
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
            break;\
        }\
        else if( gFLAGS & COM_PA_HOT_FLAG ){\
            /*PA HOT: WAIT FOR TIMEOUT*/\
            gCOM_PA_COOLING_TIMEOUT.attach(&after_cooling_pa, COM_PA_COOLING_TIME_LIMIT);\
            /*PENDING : POWER OFF COMM TX*/\
            RX1M.attach(&rx_read, Serial::RxIrq);\
            gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
            break;\
        }\
        /*gPC.printf("successflly executed %u tc\r\n", execute_psc);*/\
    }\
    if( (gMASTER_STATE == TCL_STATE_COMPLETED) || (gFLAGS & COM_SESSION_TIMEOUT_FLAG) ){\
        /*gPC.printf("completed or session timed out: %x\r\n", gMASTER_STATE);*/\
        /*COMPLETED EXECUTION OF TC*/\
        gMASTER_STATE = TCL_STATE_COMPLETED;\
        COM_POWER_OFF_TX;\
        reset_all;\
        /*PENDING : ENABLE THREADS*/\
        gPAY_SPI.bulkRead_start();\
        gSESSION_TIMEOUT.detach();\
        gFLAGS = gFLAGS & (~COM_MNG_TMTC_RUNNING_FLAG);\
        gFLAGS = gFLAGS & (~COM_SESSION_FLAG);\
    }\
}