#include "SX5110.h"
#include "mbed.h"


/*******************************************
                lcd-IO初始化
********************************************/
Lcd5110::Lcd5110(LcdPins pinout)
{
    // SPI
#ifdef HW_SPI   
    LcdSpi = new SPI(pinout.mosi, NC, pinout.sclk);
    LcdSpi->format(LCD_SPI_BITS, LCD_SPI_MODE);
    LcdSpi->frequency(LCD_FREQ);
#else
    SPins = new DigitalOut*[2];
    SPins[PIN_MOSI]   = new DigitalOut(pinout.mosi);
    SPins[PIN_SCLK]   = new DigitalOut(pinout.sclk);
#endif    
    // Control Pins
    Pins = new DigitalOut*[3];
    Pins[PIN_RST]   = new DigitalOut(pinout.rst);
    Pins[PIN_SCE]   = new DigitalOut(pinout.sce);
    Pins[PIN_DC]    = new DigitalOut(pinout.dc);
    
}
/*******************************************
                lcd-初始化
********************************************/
void Lcd5110::InitLcd()
{
    ResetLcd();
#ifdef HW_SPI
    Pins[PIN_SCE]->write(1);     // Chip Select goes low    
    LcdSpi->format(LCD_SPI_BITS, LCD_SPI_MODE);
    LcdSpi->frequency(LCD_FREQ);
    Pins[PIN_SCE]->write(0);     // Chip Select goes low
#endif  
    SendCmd(0x21);//使用扩展命令设置LCD模式chip is active & horizontal addressing (H=1)
    SendCmd(0xc0);//设置VOP值lcd 电压
    SendCmd(0x20);//使用基本命令,水平寻址                                       (H=0)
    SendCmd(0x0c);//设定显示模式，正常显示display in normal m
    clear();
}
/*******************************************
                lcd-reset
********************************************/
void Lcd5110::ResetLcd()
{
    Pins[PIN_RST]->write(0);    // Reset goes low
    wait(0.01);
    Pins[PIN_RST]->write(1);    // Reset goes high
}

void Lcd5110::SendCmd(char cmd)
{
    Pins[PIN_SCE]->write(0);     // CE goes low 
    Pins[PIN_DC]->write(0);     // Data/CMD goes low
#ifdef HW_SPI   
    LcdSpi->write(cmd);         // Command gets sent
#else
    for(unsigned char i=0;i<8;i++)
    {
        if(cmd&0x80)
            SPins[PIN_MOSI]->write(1);
        else
            SPins[PIN_MOSI]->write(0);      
        SPins[PIN_SCLK]->write(0);
        cmd=cmd<<1;
        SPins[PIN_SCLK]->write(1);
    }
#endif  
    Pins[PIN_DC]->write(1);     // Data/CMD goes back to Data mode
    Pins[PIN_SCE]->write(1);     // CE goes high    
}

void Lcd5110::SendData(char data)
{
    Pins[PIN_SCE]->write(0);     // CE goes low 
    Pins[PIN_DC]->write(1);     // Data/CMD goes low
#ifdef HW_SPI   
    LcdSpi->write(data);         // Command gets sent
#else
    for(unsigned char i=0;i<8;i++)
    {
        if(data&0x80)
            SPins[PIN_MOSI]->write(1);
        else
            SPins[PIN_MOSI]->write(0);      
        SPins[PIN_SCLK]->write(0);
        data=data<<1;
        SPins[PIN_SCLK]->write(1);
    }
#endif  
    Pins[PIN_SCE]->write(1);     // CE goes high    
}

void Lcd5110::clear()
{
    unsigned char i,j;
    SendCmd(0x0c);//设定显示模式，正常显示  
    SendCmd(0x80);//设置RAM起始地址
    for(j=0;j<LCD_Y_MAX;j++)
    {
        for(i=0;i<LCD_X_MAX;i++)
        {
            SendData(0);
        }
    }
}

void Lcd5110::TestLcd(char test_pattern)
{
    SendCmd(0x0c);//设定显示模式，正常显示  
    SendCmd(0x80);//设置RAM起始地址
    for(int tick = 0; tick < (LCD_Y_MAX*LCD_X_MAX); tick++)
        {
            SendData(test_pattern);         // Command gets sent
            wait(0.005);
        }
}

/********************************************
           set_xy
*********************************************/
void Lcd5110::set_xy(unsigned char x,unsigned char y)
{
    SendCmd(0x20);//H=0
    SendCmd(0x80|x);//x-0 to 83
    SendCmd(0x40|y);//y-0 to 5
}

/*********************************************
       display a asciifont6*8
*********************************************/
void Lcd5110::write_char(char c)
{
    unsigned char line;
    c-=32;
    for(line=0;line<LCD_Y_MAX;line++)
    SendData(ASCII[c][line]);
}

/*********************************************
        英文字符串显示函数
**********************************************/
void Lcd5110::write_stringxy(unsigned char x,unsigned char y,char *p)
{
    set_xy(x,y);
    while(*p)
    {
        write_char(*p);
        p++;
    }
}

/*********************************************
        英文字符串显示函数
**********************************************/
void Lcd5110::write_string(char *p)
{
    while(*p)
    {
        write_char(*p);
        p++;
    }
}
/*
转换数字到字符串
*/
char* Lcd5110::NumToStr(int num)
{
    if(num <= 0)
        return "0";

    double length = 0;
    int tlen = 0;
    int temp = 1;
    char c;
    
    // Get number of digits
    while( temp <= num )
    {
        temp *= 10;
        length++;
    }
    tlen = length;
    char* numString = new char[tlen+1];
    
    // Convert each place in number to a stand-alone representative number
    temp = 0;
    for(int idx = pow(10, length); idx>1; idx = (idx/10))
    {
        c = (char)( ((num % idx)-(num % (idx/10)))/(idx/10) + 48);
        numString[temp] = c;
        temp++;
    }
    numString[temp] = '\0';
    return numString;
}

/*
关闭5110
*/
void Lcd5110::ShutdownLcd()
{
    clear();
    SendCmd( 0x08 );
    SendCmd( 0x25 );
}

Lcd5110::~Lcd5110()
{
    ShutdownLcd();
}
