/*
Warning!
  When exporting and using it, increase the following stack size.
  
  [EthernetInterface/lwip/lwipopts.h]---------
  #define TCPIP_THREAD_STACKSIZE      1024
  ->
  #define TCPIP_THREAD_STACKSIZE      2048
  --------------------------------------------
*/

/*
This works with the following library.
  mbed-rtos : revision 115
*/

#include "Milkcocoa.h"

/* Please change the following macro definition to your setting. */
#define WLAN_SSID               ("SSIDofYourAP")                // SSID
#define WLAN_PSK                ("PSKofYourAP")                 // PSK(Pre-Shared Key)

#define MILKCOCOA_APP_ID      "...YOUR_MILKCOCOA_APP_ID..."
#define MILKCOCOA_DATASTORE   "mbed"
#define MILKCOCOA_SERVERPORT  1883

extern void onpush(MQTT::MessageData& md);

const char MQTT_SERVER[]  = MILKCOCOA_APP_ID ".mlkcca.com";
const char MQTT_CLIENTID[] = __TIME__ MILKCOCOA_APP_ID;

DigitalOut  red_led(LED1);              // On: error
DigitalOut  green_led(LED2);            // On: WLAN has been connected
Serial pc(USBTX, USBRX);

/** Main function
 *
 */
int main() {
    pc.baud(9600);
    MQTTBP3595 *ipstack = new MQTTBP3595(WLAN_SSID, WLAN_PSK);
    MClient *client = new MClient(ipstack);
    Milkcocoa *milkcocoa = new Milkcocoa(client, MQTT_SERVER, MILKCOCOA_SERVERPORT, MILKCOCOA_APP_ID, MQTT_CLIENTID);

    pc.printf("Milkcocoa mbed ver demo\n\r\n\r\n\r");
    
    milkcocoa->connect();
    pc.printf("\n\rEther connected\n\r");
    
    pc.printf("%d\n\r",milkcocoa->on(MILKCOCOA_DATASTORE, "push", onpush));

    while(1) {
        milkcocoa->loop();
        
        DataElement elem = DataElement();
        elem.setValue("v", 1);
        
        milkcocoa->push(MILKCOCOA_DATASTORE, elem);
        wait(7.0);
    }
}

void onpush(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    DataElement de = DataElement((char*)message.payload);
    pc.printf("onpush\n\r");
    pc.printf("%d\n\r",de.getInt("v"));
}