/**
 * This is a class to drive 4D systems screens with Picaso graphics processors
 * 
 * This is a port of the 4D systems Picaso Serial Linux Library
 * Copyright (c) 2014 4D Systems PTY Ltd, Sydney, Australia
 * From https://github.com/4dsystems/Picaso-Serial-Linux-Library, retrieved March 5, 2015
 * 
 * Graphics Command Functions. Updated October, 27, 2016.
 *
 * All software in this library is provided without warranty; use at your own risk.
 */
#include "mbed.h"
#include "Picaso_enums.h"
#include "uLCD_4D_Picaso.h"


uint16_t uLCD_4D_Picaso::gfx_BevelShadow(uint16_t  Value)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_BevelShadow >> 8 ;
  towrite[1]= F_gfx_BevelShadow ;
  towrite[2]= Value >> 8 ;
  towrite[3]= Value ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

uint16_t uLCD_4D_Picaso::gfx_BevelWidth(uint16_t  Value)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_BevelWidth >> 8 ;
  towrite[1]= F_gfx_BevelWidth ;
  towrite[2]= Value >> 8 ;
  towrite[3]= Value ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

Picaso::Color uLCD_4D_Picaso::gfx_BGcolour(Picaso::Color Color)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_BGcolour >> 8 ;
  towrite[1]= F_gfx_BGcolour ;
  towrite[2]= Color >> 8 ;
  towrite[3]= Color ;
  WriteBytes(towrite, 4) ;
  return (Picaso::Color) GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Button(Picaso::ButtonState Up, uint16_t  x, uint16_t  y, Picaso::Color buttonColour, Picaso::Color txtColour, Picaso::Font font, uint16_t  txtWidth, uint16_t  txtHeight, char *   text)
{
  char  towrite[18] ;
  towrite[0]= F_gfx_Button >> 8 ;
  towrite[1]= F_gfx_Button ;
  towrite[2]= Up >> 8 ;
  towrite[3]= Up ;
  towrite[4]= x >> 8 ;
  towrite[5]= x ;
  towrite[6]= y >> 8 ;
  towrite[7]= y ;
  towrite[8]= buttonColour >> 8 ;
  towrite[9]= buttonColour ;
  towrite[10]= txtColour >> 8 ;
  towrite[11]= txtColour ;
  towrite[12]= font >> 8 ;
  towrite[13]= font ;
  towrite[14]= txtWidth >> 8 ;
  towrite[15]= txtWidth ;
  towrite[16]= txtHeight >> 8 ;
  towrite[17]= txtHeight ;
  WriteBytes(towrite, 18) ;
  WriteChars( text) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_ChangeColour(uint16_t  OldColor, uint16_t  NewColor)
{
  char  towrite[6] ;

  towrite[0]= F_gfx_ChangeColour >> 8 ;
  towrite[1]= F_gfx_ChangeColour ;
  towrite[2]= OldColor >> 8 ;
  towrite[3]= OldColor ;
  towrite[4]= NewColor >> 8 ;
  towrite[5]= NewColor ;
  WriteBytes(towrite, 6) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Circle(uint16_t  X, uint16_t  Y, uint16_t  Radius, Picaso::Color Color)
{
  char  towrite[10] ;

  towrite[0]= F_gfx_Circle >> 8 ;
  towrite[1]= F_gfx_Circle ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  towrite[6]= Radius >> 8 ;
  towrite[7]= Radius ;
  towrite[8]= Color >> 8 ;
  towrite[9]= Color ;
  WriteBytes(towrite, 10) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_CircleFilled(uint16_t  X, uint16_t  Y, uint16_t  Radius, Picaso::Color Color)
{
  char  towrite[10] ;

  towrite[0]= F_gfx_CircleFilled >> 8 ;
  towrite[1]= F_gfx_CircleFilled ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  towrite[6]= Radius >> 8 ;
  towrite[7]= Radius ;
  towrite[8]= Color >> 8 ;
  towrite[9]= Color ;
  WriteBytes(towrite, 10) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Clipping(uint16_t  OnOff)
{
  char  towrite[4] ;

  towrite[0]= F_gfx_Clipping >> 8 ;
  towrite[1]= F_gfx_Clipping ;
  towrite[2]= OnOff >> 8 ;
  towrite[3]= OnOff ;
  WriteBytes(towrite, 4) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_ClipWindow(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2)
{
  char  towrite[10] ;

  towrite[0]= F_gfx_ClipWindow >> 8 ;
  towrite[1]= F_gfx_ClipWindow ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  WriteBytes(towrite, 10) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Cls()
{
  char  towrite[2] ;
  towrite[0]= F_gfx_Cls >> 8 ;
  towrite[1]= F_gfx_Cls ;
  WriteBytes(towrite, 2);
  GetAck();
}

uint16_t uLCD_4D_Picaso::gfx_Contrast(uint16_t  Contrast)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_Contrast >> 8 ;
  towrite[1]= F_gfx_Contrast ;
  towrite[2]= Contrast >> 8 ;
  towrite[3]= Contrast ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Ellipse(uint16_t  X, uint16_t  Y, uint16_t  Xrad, uint16_t  Yrad, Picaso::Color Color)
{
  char  towrite[12] ;
  towrite[0]= F_gfx_Ellipse >> 8 ;
  towrite[1]= F_gfx_Ellipse ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  towrite[6]= Xrad >> 8 ;
  towrite[7]= Xrad ;
  towrite[8]= Yrad >> 8 ;
  towrite[9]= Yrad ;
  towrite[10]= Color >> 8 ;
  towrite[11]= Color ;
  WriteBytes(towrite, 12) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_EllipseFilled(uint16_t  X, uint16_t  Y, uint16_t  Xrad, uint16_t  Yrad, Picaso::Color Color)
{
  char  towrite[12] ;
  towrite[0]= F_gfx_EllipseFilled >> 8 ;
  towrite[1]= F_gfx_EllipseFilled ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  towrite[6]= Xrad >> 8 ;
  towrite[7]= Xrad ;
  towrite[8]= Yrad >> 8 ;
  towrite[9]= Yrad ;
  towrite[10]= Color >> 8 ;
  towrite[11]= Color ;
  WriteBytes(towrite, 12) ;
  GetAck() ;
}

uint16_t uLCD_4D_Picaso::gfx_FrameDelay(uint16_t  Msec)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_FrameDelay >> 8 ;
  towrite[1]= F_gfx_FrameDelay ;
  towrite[2]= Msec >> 8 ;
  towrite[3]= Msec ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

uint16_t uLCD_4D_Picaso::gfx_Get(Picaso::GFXGetMode  Mode)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_Get >> 8 ;
  towrite[1]= F_gfx_Get ;
  towrite[2]= Mode >> 8 ;
  towrite[3]= Mode ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

Picaso::Color uLCD_4D_Picaso::gfx_GetPixel(uint16_t  X, uint16_t  Y)
{
  char  towrite[6] ;
  towrite[0]= F_gfx_GetPixel >> 8 ;
  towrite[1]= F_gfx_GetPixel ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  WriteBytes(towrite, 6) ;
  return (Picaso::Color) GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Line(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, Picaso::Color Color)
{
  char  towrite[12] ;
  towrite[0]= F_gfx_Line >> 8 ;
  towrite[1]= F_gfx_Line ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  towrite[10]= Color >> 8 ;
  towrite[11]= Color ;
  WriteBytes(towrite, 12) ;
  GetAck() ;
}

uint16_t uLCD_4D_Picaso::gfx_LinePattern(uint16_t  Pattern)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_LinePattern >> 8 ;
  towrite[1]= F_gfx_LinePattern ;
  towrite[2]= Pattern >> 8 ;
  towrite[3]= Pattern ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_LineTo(uint16_t  X, uint16_t  Y)
{
  char  towrite[6] ;
  towrite[0]= F_gfx_LineTo >> 8 ;
  towrite[1]= F_gfx_LineTo ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  WriteBytes(towrite, 6) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_MoveTo(uint16_t  X, uint16_t  Y)
{
  char  towrite[6] ;
  towrite[0]= F_gfx_MoveTo >> 8 ;
  towrite[1]= F_gfx_MoveTo ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  WriteBytes(towrite, 6) ;
  GetAck() ;
}

uint16_t uLCD_4D_Picaso::gfx_Orbit(uint16_t  Angle, uint16_t  Distance, uint16_t *  Xdest, uint16_t *  Ydest)
{
  char  towrite[6] ;
  towrite[0]= F_gfx_Orbit >> 8 ;
  towrite[1]= F_gfx_Orbit ;
  towrite[2]= Angle >> 8 ;
  towrite[3]= Angle ;
  towrite[4]= Distance >> 8 ;
  towrite[5]= Distance ;
  WriteBytes(towrite, 6) ;
  GetAck2Words(Xdest,Ydest) ;
  return 0 ;
}

Picaso::Color uLCD_4D_Picaso::gfx_OutlineColour(Picaso::Color Color) {
  char  towrite[4] ;
  towrite[0]= F_gfx_OutlineColour >> 8 ;
  towrite[1]= F_gfx_OutlineColour ;
  towrite[2]= Color >> 8 ;
  towrite[3]= Color ;
  WriteBytes(towrite, 4) ;
  return (Picaso::Color) GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Panel(Picaso::PanelState Raised, uint16_t  X, uint16_t  Y, uint16_t  Width, uint16_t  Height, Picaso::Color Color)
{
  char  towrite[14] ;
  towrite[0]= F_gfx_Panel >> 8 ;
  towrite[1]= F_gfx_Panel ;
  towrite[2]= Raised >> 8 ;
  towrite[3]= Raised ;
  towrite[4]= X >> 8 ;
  towrite[5]= X ;
  towrite[6]= Y >> 8 ;
  towrite[7]= Y ;
  towrite[8]= Width >> 8 ;
  towrite[9]= Width ;
  towrite[10]= Height >> 8 ;
  towrite[11]= Height ;
  towrite[12]= Color >> 8 ;
  towrite[13]= Color ;
  WriteBytes(towrite, 14) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Polygon(uint16_t  n, uint16_t*  Xvalues, uint16_t*  Yvalues, Picaso::Color Color)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_Polygon >> 8 ;
  towrite[1]= F_gfx_Polygon ;
  towrite[2]= n >> 8 ;
  towrite[3]= n ;
  WriteBytes(towrite, 4) ;
  WriteWords(Xvalues, n) ;
  WriteWords(Yvalues, n) ;
  towrite[0]= Color >> 8 ;
  towrite[1]= Color ;
  WriteBytes(towrite, 2) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_PolygonFilled(uint16_t  n, uint16_t*  Xvalues, uint16_t*  Yvalues, Picaso::Color Color)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_PolygonFilled >> 8 ;
  towrite[1]= F_gfx_PolygonFilled ;
  towrite[2]= n >> 8 ;
  towrite[3]= n ;
  WriteBytes(towrite, 4) ;
  WriteWords(Xvalues, n) ;
  WriteWords(Yvalues, n) ;
  towrite[0]= Color >> 8 ;
  towrite[1]= Color ;
  WriteBytes(towrite, 2) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Polyline(uint16_t  n, uint16_t*  Xvalues, uint16_t*  Yvalues, Picaso::Color Color)
{
  char  towrite[4] ;
  towrite[0]= F_gfx_Polyline >> 8 ;
  towrite[1]= F_gfx_Polyline ;
  towrite[2]= n >> 8 ;
  towrite[3]= n ;
  WriteBytes(towrite, 4) ;
  WriteWords(Xvalues, n) ;
  WriteWords(Yvalues, n) ;
  towrite[0]= Color >> 8 ;
  towrite[1]= Color ;
  WriteBytes(towrite, 2) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_PutPixel(uint16_t  X, uint16_t  Y, Picaso::Color Color)
{
  char  towrite[8] ;
  towrite[0]= F_gfx_PutPixel >> 8 ;
  towrite[1]= F_gfx_PutPixel ;
  towrite[2]= X >> 8 ;
  towrite[3]= X ;
  towrite[4]= Y >> 8 ;
  towrite[5]= Y ;
  towrite[6]= Color >> 8 ;
  towrite[7]= Color ;
  WriteBytes(towrite, 8) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_Rectangle(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, Picaso::Color Color)
{
  char  towrite[12] ;
  towrite[0]= F_gfx_Rectangle >> 8 ;
  towrite[1]= F_gfx_Rectangle ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  towrite[10]= Color >> 8 ;
  towrite[11]= Color ;
  WriteBytes(towrite, 12) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_RectangleFilled(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, Picaso::Color Color)
{
  char  towrite[12] ;
  towrite[0]= F_gfx_RectangleFilled >> 8 ;
  towrite[1]= F_gfx_RectangleFilled ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  towrite[10]= Color >> 8 ;
  towrite[11]= Color ;
  WriteBytes(towrite, 12) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_ScreenCopyPaste(uint16_t  Xs, uint16_t  Ys, uint16_t  Xd, uint16_t  Yd, uint16_t  Width, uint16_t  Height)
{
  char  towrite[14] ;
  towrite[0]= F_gfx_ScreenCopyPaste >> 8 ;
  towrite[1]= F_gfx_ScreenCopyPaste ;
  towrite[2]= Xs >> 8 ;
  towrite[3]= Xs ;
  towrite[4]= Ys >> 8 ;
  towrite[5]= Ys ;
  towrite[6]= Xd >> 8 ;
  towrite[7]= Xd ;
  towrite[8]= Yd >> 8 ;
  towrite[9]= Yd ;
  towrite[10]= Width >> 8 ;
  towrite[11]= Width ;
  towrite[12]= Height >> 8 ;
  towrite[13]= Height ;
  WriteBytes(towrite, 14) ;
  GetAck() ;
}

Picaso::ScreenMode uLCD_4D_Picaso::gfx_ScreenMode(Picaso::ScreenMode ScreenMode)
{
  char  towrite[4] ;

  towrite[0]= F_gfx_ScreenMode >> 8 ;
  towrite[1]= F_gfx_ScreenMode ;
  towrite[2]= ScreenMode >> 8 ;
  towrite[3]= ScreenMode ;
  WriteBytes(towrite, 4) ;
  return (Picaso::ScreenMode) GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Set(Picaso::GFXSetFunc Func, uint16_t  Value)
{
  char  towrite[6] ;

  towrite[0]= F_gfx_Set >> 8 ;
  towrite[1]= F_gfx_Set ;
  towrite[2]= Func >> 8 ;
  towrite[3]= Func ;
  towrite[4]= Value >> 8 ;
  towrite[5]= Value ;
  WriteBytes(towrite, 6) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_SetClipRegion()
{
  char  towrite[2] ;

  towrite[0]= F_gfx_SetClipRegion >> 8 ;
  towrite[1]= F_gfx_SetClipRegion ;
  WriteBytes(towrite, 2) ;
  GetAck() ;
}

uint16_t uLCD_4D_Picaso::gfx_Slider(Picaso::SliderState Mode, uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, Picaso::Color Color, uint16_t  Scale, uint16_t  Value)
{
  char  towrite[18] ;

  towrite[0]= F_gfx_Slider >> 8 ;
  towrite[1]= F_gfx_Slider ;
  towrite[2]= Mode >> 8 ;
  towrite[3]= Mode ;
  towrite[4]= X1 >> 8 ;
  towrite[5]= X1 ;
  towrite[6]= Y1 >> 8 ;
  towrite[7]= Y1 ;
  towrite[8]= X2 >> 8 ;
  towrite[9]= X2 ;
  towrite[10]= Y2 >> 8 ;
  towrite[11]= Y2 ;
  towrite[12]= Color >> 8 ;
  towrite[13]= Color ;
  towrite[14]= Scale >> 8 ;
  towrite[15]= Scale ;
  towrite[16]= Value >> 8 ;
  towrite[17]= Value ;
  WriteBytes(towrite, 18) ;
  return GetAckResp() ;
}

uint16_t uLCD_4D_Picaso::gfx_Transparency(uint16_t  OnOff)
{
  char  towrite[4] ;

  towrite[0]= F_gfx_Transparency >> 8 ;
  towrite[1]= F_gfx_Transparency ;
  towrite[2]= OnOff >> 8 ;
  towrite[3]= OnOff ;
  WriteBytes(towrite, 4) ;
  return GetAckResp() ;
}

Picaso::Color uLCD_4D_Picaso::gfx_TransparentColour(Picaso::Color Color)
{
  char  towrite[4] ;

  towrite[0]= F_gfx_TransparentColour >> 8 ;
  towrite[1]= F_gfx_TransparentColour ;
  towrite[2]= Color >> 8 ;
  towrite[3]= Color ;
  WriteBytes(towrite, 4) ;
  return (Picaso::Color) GetAckResp() ;
}

void uLCD_4D_Picaso::gfx_Triangle(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, uint16_t  X3, uint16_t  Y3, Picaso::Color Color)
{
  char  towrite[16] ;

  towrite[0]= F_gfx_Triangle >> 8 ;
  towrite[1]= F_gfx_Triangle ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  towrite[10]= X3 >> 8 ;
  towrite[11]= X3 ;
  towrite[12]= Y3 >> 8 ;
  towrite[13]= Y3 ;
  towrite[14]= Color >> 8 ;
  towrite[15]= Color ;
  WriteBytes(towrite, 16) ;
  GetAck() ;
}

void uLCD_4D_Picaso::gfx_TriangleFilled(uint16_t  X1, uint16_t  Y1, uint16_t  X2, uint16_t  Y2, uint16_t  X3, uint16_t  Y3, Picaso::Color Color)
{
  char  towrite[16] ;
  towrite[0]= F_gfx_TriangleFilled >> 8 ;
  towrite[1]= F_gfx_TriangleFilled ;
  towrite[2]= X1 >> 8 ;
  towrite[3]= X1 ;
  towrite[4]= Y1 >> 8 ;
  towrite[5]= Y1 ;
  towrite[6]= X2 >> 8 ;
  towrite[7]= X2 ;
  towrite[8]= Y2 >> 8 ;
  towrite[9]= Y2 ;
  towrite[10]= X3 >> 8 ;
  towrite[11]= X3 ;
  towrite[12]= Y3 >> 8 ;
  towrite[13]= Y3 ;
  towrite[14]= Color >> 8 ;
  towrite[15]= Color ;
  WriteBytes(towrite, 16) ;
  GetAck() ;
}
