#include "mbed.h"


#include "unzen.h"          // audio framework include file
#include "umb_adau1361a.h"  // audio codec contoler include file
#include "amakusa.h"   // audio signal processing class library.
 
#define CODEC_I2C_ADDR 0x38 // Address of the ADAU-1361A
 
DigitalOut myled1(LED1);
 
amakusa::OSCSinCos osc( 440.0, 48000 );    // freq=440Hz, Fs=48kHz.
 
   // customer signal processing initialization call back.
void init_callback(
           unsigned int block_size     // block size [sample]
           )
{
       // place initialization code here
}
 
 
   // customer signal processing call back.
void process_callback(
           float rx_left_buffer[],     // array of the left input samples
           float rx_right_buffer[],    // array of the right input samples
           float tx_left_buffer[],     // place to write the left output samples
           float tx_right_buffer[],    // place to write the left output samples
           unsigned int block_size     // block size [sample]
           )
{
       // generate tone.
   osc.run( tx_left_buffer, block_size );

        // copy left to right   
   for ( int i=0; i<block_size; i++)   // for all sample
   {
       tx_right_buffer[i] = tx_left_buffer[i] *= 0.5F;
       
   }
}
 
 
 
int main() 
{    
       // I2C is essential to talk with ADAU1361
   I2C i2c(D14, D15);
 
       // create an audio codec contoler
    shimabara::UMB_ADAU1361A codec(shimabara::Fs_48, i2c, CODEC_I2C_ADDR );     // Fs can be Fs_32, Fs_441, Fs_48, Fs_96
 
      // create an audio framework by singlton pattern
   unzen::Framework audio;
 
        // Set I3C clock to 100kHz
   i2c.frequency( 100000 );
 
 
       // Configure the optional block size of signal processing. By default, it is 1[Sample] 
//    audio.set_block_size(16);
 
   
       // Start the ADAU1361. Audio codec starts to generate the I2C signals 
   codec.start();
 
       // Start the audio framework on ARM processor.  
   audio.start( init_callback, process_callback);     // path the initializaiton and process call back to framework 
 
   codec.set_hp_output_gain( -3, -3 );
   codec.set_line_output_gain( -3, -3 );
 
       // periodically changing gain for test
   while(1)     
   {
       /*
       myled1 = 1;
       wait(0.2);
       myled1 = 0;
       wait(0.2);
       */
   }
}