#include "unzen.h"          // audio framework include file
#include "umb_adau1361a.h"     // audio codec contoler include file
#include "mbed.h"

#define CODEC_I2C_ADDR 0x38

    // for debug
DigitalOut myled1(LED1);



    // customer signal processing initialization call back.
void init_callback(
            unsigned int block_size     // block size [sample]
            )
{
        // place initialization code here
}


    // customer signal processing call back.
void process_callback(
            float rx_left_buffer[],     // array of the left input samples
            float rx_right_buffer[],    // array of the right input samples
            float tx_left_buffer[],     // place to write the left output samples
            float tx_right_buffer[],    // place to write the left output samples
            unsigned int block_size     // block size [sample]
            )
{
        // Sample processing
    for ( int i=0; i<block_size; i++)   // for all sample
    {
        tx_left_buffer[i] = rx_left_buffer[i];      // copy from input to output
        tx_right_buffer[i] = rx_right_buffer[i];
        
    }
}


int main() 
{    
        // I2C is essential to talk with ADAU1361
    I2C i2c(p32, p31);  // SDA, SDC of LPC4088 I2C0

        // create an audio codec contoler
    shimabara::UMB_ADAU1361A codec(shimabara::Fs_32, i2c, CODEC_I2C_ADDR ); // 
//    shimabara::UMB_ADAU1361A codec(shimabara::Fs_441, i2c, CODEC_I2C_ADDR );
//    shimabara::UMB_ADAU1361A codec(shimabara::Fs_48, i2c, CODEC_I2C_ADDR );
//    shimabara::UMB_ADAU1361A codec(shimabara::Fs_96, i2c, CODEC_I2C_ADDR );

       // create an audio framework by singlton pattern
    unzen::Framework audio;
 
         /* Set I3C clock to 100kHz*/
    i2c.frequency( 100000 );


        /* Configure the optional block size of signal processing. By default, it is 1[Sample] */ 
//    audio.set_block_size(4);

        /* for debug. Optional pre/post call backs. This block can be removed in the real application */

//    audio.set_pre_interrupt_callback(pre_int);
//    audio.set_post_interrupt_callback(post_int);
//    audio.set_pre_process_callback(pre_proc);
//    audio.set_post_process_callback(post_proc);


    
        /* Start the ADAU1361. Audio codec starts to generate the I2C signals  */
   codec.start();

        /* Start the audio framework on ARM processor.  */ 
   audio.start( init_callback, process_callback);     // path the initializaiton and process call back to framework 

   
    
    codec.set_hp_output_gain( 0, 0 );
    
    while(1)     
    {
        for ( int i=-15; i<4; i++ )
        {
            codec.set_hp_output_gain( i, i );
            codec.set_line_output_gain( i, i );
            myled1 = 1;
            wait(0.25);
            myled1 = 0;
            wait(0.25);
         }
    }
}



//*************** debug functions ******************

