#include "mbed.h"
#include "ukifune.h"
#include "unzen.h"
#include "amakusa.h"

#define AD7999 (0x29<<1)
#define ADCBUFSIZE 8
#define ADCNUM 8

namespace ukifune
{
        // 
    DigitalOut *leds[12];
    DigitalIn *switches[16];
    float adc[ADCNUM];
    amakusa::Hysteresis * hysteresis[ADCNUM];
    
        
        // Test points
    DigitalOut TP1( PE_12 ); // TP1 for _interrupt _flag.
    DigitalOut TP2( PF_14 ); // TP2 for _process _flag.

        // LED    
    DigitalOut LED1_1(PE_7);
    DigitalOut LED1_2(PF_10);
    DigitalOut LED1_3(PF_4);
    DigitalOut LED1_4(PC_4);
    
    DigitalOut LED2_1(PB_13);
    DigitalOut LED2_2(PB_5);
    DigitalOut LED2_3(PB_14);
    DigitalOut LED2_4(PB_15);
    
    DigitalOut LED3_1(PB_6);
    DigitalOut LED3_2(PA_11);
    DigitalOut LED3_3(PA_5);
    DigitalOut LED3_4(PC_6);
    
        // Mode Button
    DigitalIn SWM1(PD_14);
    DigitalIn SWM2(PB_4);
    DigitalIn SWM3(PA_12);
    
        // Key Button
    DigitalIn SWK1(PE_10);
    DigitalIn SWK2(PD_15);
    DigitalIn SWK3(PD_11);
    DigitalIn SWK4(PE_8);
    DigitalIn SWK5(PF_5);
    DigitalIn SWK6(PA_10);
    DigitalIn SWK7(PB_1);
    DigitalIn SWK8(PB_12);
    DigitalIn SWK9(PA_7);
    DigitalIn SWK10(PA_6);
    DigitalIn SWK11(PC_7);
    DigitalIn SWK12(PC_5);
    DigitalIn SWK13(PC_8);


        // I2S ports for potentiometer
    I2C i2c3(PC_9, PA_8);  // SDA, SCL of I2C3
    I2C i2c4(PD_13, PD_12);  // SDA, SCL of I2C4
    
    void assert_process_flag( void )
    {
        TP2 = 1;
    }
    
    void deassert_process_flag( void )
    {
        TP2 = 0;
    }
    
    void assert_interrupt_flag( void )
    {
        TP1 = 1;
    }
    
    void deassert_interrupt_flag( void )
    {
        TP1 = 0;
    }
    
    void init( unzen::Framework *audio)
    {
            
            // Setup interrupt/process activity flag.
        audio->set_pre_interrupt_callback( assert_interrupt_flag );
        audio->set_post_interrupt_callback( deassert_interrupt_flag );
        audio->set_pre_process_callback( assert_process_flag );
        audio->set_post_process_callback( deassert_process_flag );
        
            // Setup LEDs
        leds[ led1_1 ] = &LED1_1;
        leds[ led1_2 ] = &LED1_2;
        leds[ led1_3 ] = &LED1_3;
        leds[ led1_4 ] = &LED1_4;
        
        leds[ led2_1 ] = &LED2_1;
        leds[ led2_2 ] = &LED2_2;
        leds[ led2_3 ] = &LED2_3;
        leds[ led2_4 ] = &LED2_4;

        leds[ led3_1 ] = &LED3_1;
        leds[ led3_2 ] = &LED3_2;
        leds[ led3_3 ] = &LED3_3;
        leds[ led3_4 ] = &LED3_4;
            
            // Setup Switches
        switches[ swm1 ] = & SWM1;
        switches[ swm2 ] = & SWM2;
        switches[ swm3 ] = & SWM3;
        switches[ swk1 ] = & SWK1;
        switches[ swk2 ] = & SWK2;
        switches[ swk3 ] = & SWK3; 
        switches[ swk4 ] = & SWK4;
        switches[ swk5 ] = & SWK5;
        switches[ swk6 ] = & SWK6;
        switches[ swk7 ] = & SWK7;
        switches[ swk8 ] = & SWK8;
        switches[ swk9 ] = & SWK9;
        switches[ swk10 ] = & SWK10;
        switches[ swk11 ] = & SWK11;
        switches[ swk12 ] = & SWK12;
        switches[ swk13 ] = & SWK13;
        
        for ( int i= 0; i<ADCNUM; i++ )
            hysteresis[ i ] = new amakusa::Hysteresis((int32_t)0,(int32_t) 255);
            
    }
    
    void get_button_state(
            uint32_t & pusshing, 
            uint32_t & releasing, 
            uint32_t & holding )
    {
        static int last_button  = 0;
        int current_button = 0;
        int index;
        
            // get current button mask pattern
        index = 0;
        for ( int sw = 0; sw < 16; sw ++ )
        {
            if ( *(switches[sw]) )
                current_button |= 1<<index;
            index ++;
        }
        
            // return pushed button
        holding = current_button; 
        
            // buttons which are pushed from last state.
        pusshing =  ( last_button ^ current_button ) & current_button;
        
            // buttons which are released from last state
        releasing = ( last_button ^ current_button ) & last_button;
        
        last_button = current_button;
    }

    void turn_led_on( enum LED led )
    {
        *( leds[ led ] ) = 1;
    }
    
    void turn_led_off( enum LED led )
    {
        *( leds[ led ] ) = 0;
    }

    void toggle_led( enum LED led )
    {
        *( leds[ led ] ) = ! get_led_state( led );
    }

    int get_led_state( enum LED led )
    {
        return *( leds[ led ] );
    }

    float get_volume( int number )
    {
        if ( number < 0)
            return 0.0;
        if ( number >= ADCNUM )
            return 0.0;
            
        return adc[ number ];
            
    }

    void parse_adc( char * buf, int &ch, int &data )
    {
        ch = ( buf[0] & 0x30 ) >> 4;
        data = 
            ( buf[0] & 0x0F ) << 4 |
            ( buf[1] & 0xF0 ) >> 4;
        
    } 



    void tick(void)
    {
        char adcbuf[ADCBUFSIZE];
        int ch, data;
        
        i2c3.read( AD7999, adcbuf, 8);
        parse_adc(& adcbuf[0], ch, data);
        adc[ch] = hysteresis[ch]->run( data ) / 255.0;
        parse_adc(& adcbuf[2], ch, data);
        adc[ch] = hysteresis[ch]->run( data ) / 255.0;
        parse_adc(& adcbuf[4], ch, data);
        adc[ch] = hysteresis[ch]->run( data ) / 255.0;
        parse_adc(& adcbuf[6], ch, data);
        adc[ch] = hysteresis[ch]->run( data ) / 255.0;
        
        i2c4.read( AD7999, adcbuf, 8);
        parse_adc(& adcbuf[0], ch, data);
        adc[ch+4] = hysteresis[ch+4]->run( data ) / 255.0;
        parse_adc(& adcbuf[2], ch, data);
        adc[ch+4] = hysteresis[ch+4]->run( data ) / 255.0;
        parse_adc(& adcbuf[4], ch, data);
        adc[ch+4] = hysteresis[ch+4]->run( data ) / 255.0;
        parse_adc(& adcbuf[6], ch, data);
        adc[ch+4] = hysteresis[ch+4]->run( data ) / 255.0;
    }


};
