#include "signal_processing.h"

/*
* Related Link
* https://www.dsprelated.com/freebooks/filters/DC_Blocker.html
* https://ccrma.stanford.edu/~jos/fp/DC_Blocker.html
*/

DCBlocker::DCBlocker(  uint32_t blockSize ) : amakusa::AbstractFilter ( blockSize )
{
    this->x_last = 0;
    this->y_last = 0;
}

void DCBlocker::run( float32_t *pSrc, float32_t *pDst )
{
        // if the parameter is non-zero, take it. If the parameter is zero, use default.
    
    for ( int i = 0; i < this->block_size; i++ )
    {
            // y = x - x * z^-1 + 0.995 * y * z^-1
        pDst[ i ] = pSrc[ i ] - this->x_last + 0.995f * this->y_last;
        this->x_last = pSrc[ i ];
        this->y_last = pDst[ i ];
    }
    
}
