#include "signal_processing.h"

/*========================= Project Dependent Method =========================*/
        // Modify this constructor to initialize your audio algorithm.
SignalProcessing::SignalProcessing( unsigned int  block_size )
{
        // place the signal processing initializing code here.
    this->volume_level = 0.0;   // sample initializaiton
    this->note = new Monophonic(block_size);      // allocate VFO
    note->set_Fs( SAMPLING_FREQUENCY );
    note->set_vfo_frequency( 440 );
    note->set_vfo_wave_form( triangle );
}   // End of constructor()
    
    
        // Modify this method to implement your audio algorithm.
void SignalProcessing::run(           
            float rx_left_buffer[],     // array of the left input samples
            float rx_right_buffer[],    // array of the right input samples
            float tx_left_buffer[],     // place to write the left output samples
            float tx_right_buffer[],    // place to write the right output samples
            unsigned int block_size     // block size [sample]
           )
{
        // place the signal processing coce here

        // VFO
    this->note->run( tx_left_buffer);
    
        // apply gain and copy to right ch.
    for ( int i= 0; i< block_size; i++ )
    {
            tx_right_buffer[i]  = tx_left_buffer[i]  *= this->volume_level;
    }
}   // End of run()
    

    // Sampling Frequency
void SignalProcessing::set_Fs( int Fs )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_Fs( Fs );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

    // Oscillation Frequency
void SignalProcessing::set_vfo_frequency( float freq )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_vfo_frequency( freq );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

    // Duty Cycle of VFO
void SignalProcessing::set_vfo_duty_cycle( float duty )
{
    duty *= 0.5f;                        // [0.0,0.5]
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_vfo_duty_cycle( duty );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

    // VFO wave form
void SignalProcessing::set_vfo_wave_form( wave_form form )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_vfo_wave_form( form );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

           
        // Set the volume level to the object.
void SignalProcessing::set_volume( float vol )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->volume_level = vol;
    this->leave_critical_section();     // now, ok to accept interrupt.
}

        // Set the lpf/hpf/bpf
void SignalProcessing::set_filter_mode( svf_mode mode )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_filter_mode( mode );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

        // Set the Q value. 
void SignalProcessing::set_filter_Q( float Q )
{
        // range of the parameter Q ( volume input ) is [0,1.0].
        // Transform it to [0.1,10]
    Q *= 9.9f;
    Q += 0.1f;
    
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_filter_Q( Q );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

        // Set the f_factor value. 
void SignalProcessing::set_filter_f_factor( float f_factor )
{
        // range of the parameter f_factor ( volume input ) is [0,1.0].
        // Transform it to [0.1,5.0]
    f_factor *= 4.9f;
    f_factor += 0.1f;
    
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_filter_f_factor( f_factor );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::eg_on(void)
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->eg_on();
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::eg_off(void)
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->eg_off();
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::set_eg_attack( float32_t attack )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_eg_attack( attack );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::set_eg_decay( float32_t decay )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_eg_decay( decay );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::set_eg_sustain( float32_t sustain )        // [0,1.0]
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_eg_sustain( sustain );
    this->leave_critical_section();     // now, ok to accept interrupt.
}

void SignalProcessing::set_eg_release ( float32_t release )        // [0,1.0]
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->note->set_eg_release( release );
    this->leave_critical_section();     // now, ok to accept interrupt.
}




/************************** skeleton dependent methond. ***********************/
        // essential members. Do not touch.
void SignalProcessing::enter_critical_section(void)
{
    __disable_irq();    // globaly forbid all interrupt
}

void SignalProcessing::leave_critical_section(void)
{
    __enable_irq();     // globaly allow all interrupts
}

