#include "signal_processing.h"


    // constructor. 
Monophonic::Monophonic( unsigned int a_block_size )
{
    this->block_size = a_block_size;
    
        // initializing the subm-odules.
    this->vfo = new VFO(block_size);      // allocate VFO
    this->dc_blocker = new DCBlocker( this->block_size );
    this->sv_filter = new SVFilter( this->block_size );
    this->eg = new EG( this->block_size );
    this->limitter = new amakusa::LimitterLinAtan( this->block_size );
    
    work_buf_a = new float32_t[block_size];
    work_buf_b = new float32_t[block_size];
    
}   // End of constructor()

Monophonic::~Monophonic( void )
{
        // initializing the subm-odules.
    delete this->vfo;
    delete this->dc_blocker;
    delete this->sv_filter;
    delete this->eg;
    delete this->limitter;
    
    delete[] work_buf_a;
    delete[] work_buf_b;
}   // End of constructor()


    
        // Run all signal processing.
void Monophonic::run(           
        float out_buffer[]    // place to write the right output samples
        )
{
        // place the signal processing coce here
    this->vfo->run( work_buf_a );
    
        // blocking DC.
    this->dc_blocker->run( work_buf_a, work_buf_b );

        // applying filter.
    this->sv_filter->run( work_buf_b, work_buf_a );
    
        // generate envelope
    this->eg->run( work_buf_b );
    
        // apply envelope
    for ( int i= 0; i< this->block_size; i++ )
        work_buf_b[ i ] *= work_buf_a[ i ];
        
        // apply amplitude limitter
    this->limitter->run( work_buf_b, out_buffer );
        
}   // End of run()
    

    // Sampling Frequency
void Monophonic::set_Fs( int Fs )
{
    this->vfo->set_Fs( Fs );
    this->sv_filter->set_Fs( Fs );
}

    // Oscillation Frequency
void Monophonic::set_vfo_frequency( float freq )
{
    this->vfo->set_frequency( freq );
    this->sv_filter->set_fc( freq );
}

    // Duty Cycle of VFO
void Monophonic::set_vfo_duty_cycle( float duty )
{
    this->vfo->set_duty_cycle( duty );
}

    // VFO wave form
void Monophonic::set_vfo_wave_form( wave_form form )
{
    this->vfo->set_wave_form( form );
}

    // SVF filter mode.
void Monophonic::set_filter_mode( svf_mode mode )
{
    this->sv_filter->set_mode( mode );
}

    // SVF Q factor
void Monophonic::set_filter_Q( float Q )
{
    this->sv_filter->set_Q( Q );
}

    // Set the f_factor value. 
void Monophonic::set_filter_f_factor( float f_factor )
{
    this->sv_filter->set_f_factor( f_factor );
}

    // Turn note on 
void Monophonic::eg_on(void)
{
    this->eg->on();
}

    // Turn note off
void Monophonic::eg_off(void)
{
    this->eg->off();
}

void Monophonic::set_eg_attack( float32_t attack )
{
    this->eg->set_attack( attack );
}
void Monophonic::set_eg_decay( float32_t decay )
{
    this->eg->set_decay( decay );
}

void Monophonic::set_eg_sustain( float32_t sustain )
{
    this->eg->set_sustain( sustain );
}

void Monophonic::set_eg_release ( float32_t release )
{
    this->eg->set_release( release );
}

