#include "signal_processing.h"

EG::EG ( int32_t a_block_size )
{
    this->block_size = a_block_size;
    
    this->state = release;
    this->set_sustain( 0.0f );
    this->current_level = 0.0f;
    this->set_attack( 0.999 );
    this->set_decay( 0.999 );
    this->set_release( 0.999 );

}

void EG::run( float32_t *pEnvelope )
{
    if ( this->state == release )
        for ( int i= 0; i< this->block_size; i++ )
            pEnvelope[i] = this->current_level = 
                this->current_level * this->release_time_constant;
    else if ( this->state == decay )
        for ( int i= 0; i< this->block_size; i++ )
            pEnvelope[i] = this->current_level = 
                ( this->current_level - this->sustain_level ) * this->decay_time_constant
                + this->sustain_level;
    else // attack
    {
        for ( int i= 0; i< this->block_size; i++ )
            pEnvelope[i] = this->current_level = 
                1.5f - 
                ( 1.5f - this->current_level ) * this->attack_time_constant;
        if ( this->current_level >= 1.0f )
            this->state = decay;
     }               
    
}

void EG::on(void)
{
    this->state = attack;
}

void EG::off(void)
{
    this->state = release;
}

void EG::set_sustain( float32_t sustain )
{
    this->sustain_level = sustain;
}

void EG::set_attack( float32_t attack )
{
    this->attack_time_constant = 1.0f - (1.0f-attack) * 0.001f;
}

void EG::set_decay( float32_t decay )
{
    this->decay_time_constant = 1.0f - (1.0f-decay) * 0.001f;
}

void EG::set_release( float32_t release )
{
    this->release_time_constant = 1.0f - (1.0f-release) * 0.001f;
}


