#include "mbed.h"

// Note : Do not touch the "unzen dependent" part. No need to read.
//        Modify the "project dependent" part.
//        Also, Modify the SignalProcessing class.


/************************** unzen dependent constants. ************************/
#define CODEC_I2C_ADDR 0x38 // Address of the ADAU-1361A


/*========================= Project Dependent Constants ======================*/
#define BLOCKSIZE 16        // number of the sample to be processed at once.
#define FS shimabara::Fs_48 // Fs can be Fs_32, Fs_441, Fs_48, Fs_96


/************************** unzen dependent include. **************************/
#include "unzen.h"          // audio framework include file
#include "umb_adau1361a.h"  // audio codec contoler include file
#include "amakusa.h"        // audio signal processing class library.
#include "ukifune.h"        // UI board support routines
#include "signal_processing.h"  // Implementaion of user signal processing.


/************************* Unzen Dependent Global Variables *******************/
    // I2C is essential to talk with ADAU1361
static I2C i2c(D14, D15);
    // create an audio codec contoler
static shimabara::UMB_ADAU1361A codec(FS, i2c, CODEC_I2C_ADDR );     
    // create an audio framework by singlton pattern
static unzen::Framework audio;
    // create a pointer to the signal processing object.
static SignalProcessing * process;


/************************* Unzen Dependent Function Prototype *****************/
    // for system usage. Do not care.
void initialize_system(void);
 

/*========================= Main program. ====================================*/
int main() 
{    
    uint32_t pushing, releasing, holding;

        // start audio. Do not touch
    initialize_system();
 
       // main loop. Signal processing is done in background.
    while(1)     
    {       // place your foreground program here.

            // get volume from UI panel, then apply it to signal processing.
        process->set_volume( ukifune::get_volume(0) );   
       
            // sample usage of button switch detection
        ukifune::get_button_state( pushing, releasing, holding);

            // pushing detection demo
        if ( pushing & (1 << ukifune::swm1 ) )      // is SWM1 switch pusshing down?
            ukifune::toggle_led( ukifune::led1_1 ); // then, toggle LED1_1 

            // releasing detection demo     
        if ( releasing & (1 << ukifune::swm2 ) )    // is SWM2 switch releasing? 
            ukifune::toggle_led( ukifune::led2_1 ); // then toggle LED2_1
       
            // holding detection demo     
        if ( holding & (1 << ukifune::swm3 ) )    // is SWM3 switch holding? 
            ukifune::turn_led_on( ukifune::led3_1 );    // then turn LED3_1 on
        else
            ukifune::turn_led_off( ukifune::led3_1 );   // else off

       
            // you have to call tick() every 20mS-50mS if you need get_volume()
        wait(0.05);
        ukifune::tick();
    }
}   // End of main


/************************* Unzen Dependent Callbacks **************************/
   // customer signal processing initialization call back.
void init_callback(
           unsigned int block_size     // block size [sample]
           )
{
       // place initialization code here
    process = new SignalProcessing( block_size );
}   // end of init_callback
 
 
   // customer signal processing call back.
void process_callback(
           float rx_left_buffer[],     // array of the left input samples
           float rx_right_buffer[],    // array of the right input samples
           float tx_left_buffer[],     // place to write the left output samples
           float tx_right_buffer[],    // place to write the right output samples
           unsigned int block_size     // block size [sample]
           )
{
       // place signal processing code here
    process->run( rx_left_buffer, rx_right_buffer, tx_left_buffer, tx_right_buffer, block_size );
}   // End of process_callback


/************************* Unzen Dependent Function implementation ************/
void initialize_system(void)
{
        // Set I3C clock to 100kHz
    i2c.frequency( 100000 );
 
        // Configure the optional block size of signal processing. By default, it is 1[Sample] 
    audio.set_block_size(BLOCKSIZE);

        // Start UI module.
    ukifune::init( & audio );
   
        // Start the ADAU1361. Audio codec starts to generate the I2C signals 
    codec.start();
        // Start the audio framework on ARM processor.  
    audio.start( init_callback, process_callback);     // path the initializaiton and process call back to framework 
 
        // Setup initial analog gain   
    codec.set_hp_output_gain( 0, 0 );
    codec.set_line_output_gain( 0, 0 );
}
