#include "signal_processing.h"

/*========================= Project Dependent Method =========================*/
        // Modify this constructor to initialize your audio algorithm.
SignalProcessing::SignalProcessing( unsigned int  block_size )
{
        // place the signal processing initializing code here.
    this->volume_level = 0.0;   // sample initializaiton
}   // End of constructor()
    
    
        // Modify this method to implement your audio algorithm.
void SignalProcessing::run(           
            float rx_left_buffer[],     // array of the left input samples
            float rx_right_buffer[],    // array of the right input samples
            float tx_left_buffer[],     // place to write the left output samples
            float tx_right_buffer[],    // place to write the right output samples
            unsigned int block_size     // block size [sample]
           )
{
        // place the signal processing coce here
    for ( int i= 0; i< block_size; i++ )
    {
            tx_left_buffer[i]  = rx_left_buffer[i]  * this->volume_level;
            tx_right_buffer[i] = rx_right_buffer[i] * this->volume_level;
    }
}   // End of run()
    
           
        // Sample method. Set the volume level to the object.
void SignalProcessing::set_volume( float vol )
{
    this->enter_critical_section();     // forbidden interrrupt.
    this->volume_level = vol;
    this->leave_critical_section();     // now, ok to accept interrupt.
}



/************************** skeleton dependent methond. ***********************/
        // essential members. Do not touch.
void SignalProcessing::enter_critical_section(void)
{
    __disable_irq();    // globaly forbid all interrupt
}

void SignalProcessing::leave_critical_section(void)
{
    __enable_irq();     // globaly allow all interrupts
}

