namespace amakusa
{
        /**
        * \brief Sine & Cosine Oscillator
        */
    class OSCSinCos
    {
    public:
            /**
            * \brief constructor
            * \param freq Frequency in Hz.
            * \param Fs Sampling frequency in Hz.
            */
        OSCSinCos( float freq, int Fs, int block_size );
            /**
            * \brief wave generator method
            * \param c Pointer to the buffer to output the sine signal.  
            * \param s Pointer to the buffer to output the cosine singal. If NULL, cosine signal will be skipped.
            * \params count Number of sample to be generated.
            */
        void run( float *s, float *c );
            /**
            * \brief wave generator method
            * \param c Pointer to the buffer to output the sine signal.  
            * \params count Number of sample to be generated.
            */
        void run( float *s ){run(s, 0);}
            /**
            * \brief set the oscillation furequncy.
            * \param freq Frequency in Hz.
            */
        void setFrequency( float freq );
            /**
            * \brief set the oscillator's internal phase
            * \param freq phase in radian.
            */
        void setPhase( float phase );        
            /**
            * \brief get the oscillation furequncy.
            * \returns Frequency in Hz.
            */
        float getFrequency();
            /**
            * \brief get the internal phase
            * \returns Phase in radian
            */
        float getPhase();
    private:
        float deltaPhase;   // deltaPhase per sample.
        int sampleFreq;     // in Hz
        int phaseInSample;  // internal phase [sample]
        int bs;             // blockSize
    };
        
}
    