#include <cstdlib>
#include <cmath>

#include "amakusa.h"

#ifndef M_PI
#define M_PI  3.141592653589793F
#endif

amakusa::OSCSinCos::OSCSinCos( float freq, int Fs, int block_size )
{
        this->sampleFreq = Fs;
        this->setFrequency( freq );
        this->setPhase( 0.0 );      // must call after setFrequenc()
        this->bs = block_size;
}

void amakusa::OSCSinCos::run( float *s, float *c)
{
    
    for ( int i=0; i<this->bs; i++ )
    {
            // to make the expression simple
        float phase = this->deltaPhase * ( i+ this->phaseInSample );
        
            // normal sind cosine
        s[i] = std::sin( phase );
            // skip cosine if c is NULL
        if ( c != NULL )
            c[i] = std::cos( phase );
            

    }
        // update the internal phase
    this->phaseInSample += this->bs;
        // truncate the phase
    while ( this->phaseInSample >= this->sampleFreq )
        this->phaseInSample -= this->sampleFreq;
}


void amakusa::OSCSinCos::setFrequency( float freq )
{
        // convert frequency to the update phase per sample.
    this->deltaPhase = 2 * M_PI * freq / this->sampleFreq;
}

    // put the phase into the range [0, 2pi)
void amakusa::OSCSinCos::setPhase( float phase )
{
        // convert phisical phase to the phase in sample.
    this->phaseInSample = phase  * this->sampleFreq / ( 2 * M_PI );
    
        // truncate phase in to [0,2pi)
    while ( this->phaseInSample < 0 )
        this->phaseInSample += this->sampleFreq;
    while ( this->phaseInSample >= this->sampleFreq )
        this->phaseInSample -= this->sampleFreq;
}

float amakusa::OSCSinCos::getFrequency()
{
        // convert sample
    return this->deltaPhase * this->sampleFreq / ( 2 * M_PI );
}
            /**
            * \brief get the internal phase
            * \returns Phase in radian
            */
float amakusa::OSCSinCos::getPhase()
{
    return this->phaseInSample * 2 * M_PI / this->sampleFreq;
}
