#include <cmath>
#include "amakusa.h"

#ifndef M_PI
#define M_PI 3.1415927F
#endif 

    void amakusa::LimitterLinAtan::run( float32_t *pSrc, float32_t *pDst)
    {
        uint32_t count = this->block_size;
        
        for ( int i=0; i<count; i++ )
        {
            if ( pSrc[i] > 0.5F )
                pDst[i] = std::atan((pSrc[i]-0.5F)*M_PI)/M_PI+0.5F;
            else if ( -0.5F > pSrc[i] )
                pDst[i] = std::atan((pSrc[i]+0.5F)*M_PI)/M_PI-0.5F;
            else
                pDst[i] = pSrc[i];

        }
    }
